/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.effects.spawn_entities.EntitySpawnConfiguration;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntityIDListEffect;
import ivorius.pandorasbox.random.DConstant;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.IConstant;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueHelper;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.weighted.WeightedEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnEntities(IValue time, IValue number, IValue entitiesPerTower, IValue nameEntities, IValue equipLevel, IValue buffLevel, ZValue spawnFromEffectCenter, List<WeightedEntity> entityIDs, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnEntities> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECSpawnEntities::time), (App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnEntities::number), (App)IValue.CODEC.optionalFieldOf("entities_per_tower", (Object)new IConstant(1)).forGetter(PBECSpawnEntities::entitiesPerTower), (App)IValue.CODEC.optionalFieldOf("named_entities", (Object)new IConstant(0)).forGetter(PBECSpawnEntities::nameEntities), (App)IValue.CODEC.optionalFieldOf("equipment_level", (Object)new IConstant(0)).forGetter(PBECSpawnEntities::equipLevel), (App)IValue.CODEC.optionalFieldOf("buff_level", (Object)new IConstant(0)).forGetter(PBECSpawnEntities::buffLevel), (App)ZValue.CODEC.fieldOf("spawn_from_effect_center").forGetter(PBECSpawnEntities::spawnFromEffectCenter), (App)WeightedEntity.CODEC.listOf().fieldOf("entities").forGetter(PBECSpawnEntities::entityIDs), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnEntities::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnEntities::valueSpawn)).apply((Applicative)instance, PBECSpawnEntities::new));

    public PBECSpawnEntities(IValue time, IValue number, IValue entitiesPerTower, IValue equipLevel, IValue buffLevel, IValue nameEntities, ZValue spawnFromEffectCenter, List<WeightedEntity> entityIDs) {
        this(time, number, entitiesPerTower, nameEntities, equipLevel, buffLevel, spawnFromEffectCenter, entityIDs, Optional.of(PBECSpawnEntities.defaultThrow()), Optional.of(PBECSpawnEntities.defaultSpawn()));
    }

    public static ValueThrow defaultThrow() {
        return new ValueThrow(new DLinear(0.1, 0.4), new DLinear(0.2, 1.0));
    }

    public static ValueSpawn defaultSpawn() {
        return new ValueSpawn(new DLinear(8.0, 30.0), new DConstant(0.0));
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int time = this.time.getValue(random);
        int number = this.number.getValue(random);
        int[] towerSize = ValueHelper.getValueRange(this.entitiesPerTower, random);
        int nameEntities = this.nameEntities.getValue(random);
        int equipLevel = this.equipLevel.getValue(random);
        int buffLevel = this.buffLevel.getValue(random);
        WeightedEntity[] entitySelection = PandorasBoxHelper.getRandomEntityList(random, this.entityIDs);
        String[][] entitiesToSpawn = new String[number][];
        for (int i = 0; i < number; ++i) {
            entitiesToSpawn[i] = new String[towerSize[0] + random.method_43048(towerSize[1] - towerSize[0] + 1)];
            for (int j = 0; j < entitiesToSpawn[i].length; ++j) {
                entitiesToSpawn[i][j] = entitySelection[random.method_43048(entitySelection.length)].entityID();
            }
        }
        return PBECSpawnEntities.constructEffect(random, entitiesToSpawn, time, nameEntities, equipLevel, buffLevel, this.spawnFromEffectCenter, this.valueThrow.orElse(null), this.valueSpawn.orElse(null));
    }

    public static PBEffect constructEffect(class_5819 random, String[][] entitiesToSpawn, int time, ZValue spawnFromEffectCenter, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        return PBECSpawnEntities.constructEffect(random, entitiesToSpawn, time, 0, 0, 0, spawnFromEffectCenter, valueThrow, valueSpawn);
    }

    public static PBEffect constructEffect(class_5819 random, String[][] entitiesToSpawn, int time, int nameEntities, int equipLevel, int buffLevel, ZValue spawnFromEffectCenter, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        boolean canSpawn = valueSpawn != null;
        boolean canThrow = valueThrow != null;
        EntitySpawnConfiguration.Builder builder = EntitySpawnConfiguration.builder(!spawnFromEffectCenter.getValue(random));
        if (canThrow && (!canSpawn || random.method_43056())) {
            return new PBEffectSpawnEntities(time, entitiesToSpawn.length, new SpawnEntityIDListEffect(entitiesToSpawn, nameEntities, equipLevel, buffLevel, PBECSpawnEntities.setEffectThrow(builder, random, valueThrow).build()));
        }
        if (canSpawn) {
            return new PBEffectSpawnEntities(time, entitiesToSpawn.length, new SpawnEntityIDListEffect(entitiesToSpawn, nameEntities, equipLevel, buffLevel, PBECSpawnEntities.setEffectSpawn(builder, random, valueSpawn).build()));
        }
        throw new RuntimeException("Both spawnRange and throwStrength are null!");
    }

    public static EntitySpawnConfiguration.Builder setEffectThrow(EntitySpawnConfiguration.Builder config, class_5819 random, ValueThrow valueThrow) {
        double[] throwX = ValueHelper.getValueRange(valueThrow.throwStrengthSide(), random);
        double[] throwY = ValueHelper.getValueRange(valueThrow.throwStrengthY(), random);
        return config.doesSpawnDirect(throwX[0], throwX[1], throwY[0], throwY[1]);
    }

    public static EntitySpawnConfiguration.Builder setEffectSpawn(EntitySpawnConfiguration.Builder config, class_5819 random, ValueSpawn valueSpawn) {
        double range = valueSpawn.spawnRange().getValue(random);
        double spawnShift = valueSpawn.spawnShift().getValue(random);
        return config.doesNotSpawnDirect(range, spawnShift);
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

