/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectPositionBased;
import ivorius.pandorasbox.effects.position.RandomExplosionsPositionEffect;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueHelper;
import ivorius.pandorasbox.random.ZChance;
import ivorius.pandorasbox.random.ZConstant;
import ivorius.pandorasbox.random.ZValue;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnExplosions(IValue time, IValue number, DValue range, DValue explosionStrength, ZValue isFlaming, ZValue isSmoking) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnExplosions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECSpawnExplosions::time), (App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnExplosions::number), (App)DValue.CODEC.fieldOf("range").forGetter(PBECSpawnExplosions::range), (App)DValue.CODEC.fieldOf("explosion_strength").forGetter(PBECSpawnExplosions::explosionStrength), (App)ZValue.CODEC.optionalFieldOf("is_flaming", (Object)new ZChance(0.3)).forGetter(PBECSpawnExplosions::isFlaming), (App)ZValue.CODEC.optionalFieldOf("is_smoking", (Object)new ZConstant(true)).forGetter(PBECSpawnExplosions::isSmoking)).apply((Applicative)instance, PBECSpawnExplosions::new));

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int time = this.time.getValue(random);
        int number = this.number.getValue(random);
        double range = this.range.getValue(random);
        double[] strength = ValueHelper.getValueRange(this.explosionStrength, random);
        boolean isFlaming = this.isFlaming.getValue(random);
        boolean isSmoking = this.isSmoking.getValue(random);
        return new PBEffectPositionBased(time, number, range, new RandomExplosionsPositionEffect((float)strength[0], (float)strength[1], isFlaming, isSmoking));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.7f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

