/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntityIDListEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.Init;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public abstract class PBEffect {
    public static final Codec<PBEffect> CODEC = Init.BOX_EFFECT_TYPE_REGISTRY.method_39673().dispatch(PBEffect::codec, mapCodec -> mapCodec);
    public static final class_9139<class_9129, PBEffect> STREAM_CODEC = class_9135.method_56896(CODEC);

    public static boolean setBlockToAirSafe(class_1937 level, class_2338 pos) {
        boolean safeDest = level.method_8320(pos).method_26215() || level.method_8320(pos).method_26214((class_1922)level, pos) >= 0.0f;
        return safeDest && level.method_8501(pos, class_2246.field_10124.method_9564());
    }

    public static boolean setBlockSafe(class_1937 level, class_2338 pos, class_2680 state) {
        boolean safeDest = level.method_8320(pos).method_26215() || level.method_8320(pos).method_26214((class_1922)level, pos) >= 0.0f;
        boolean safeSrc = state.method_26215() || state.method_26214((class_1922)level, pos) >= 0.0f;
        return safeDest && safeSrc && level.method_8501(pos, state);
    }

    public static boolean setBlockUnsafeSrc(class_1937 level, class_2338 pos, class_2680 state) {
        boolean safeDest = level.method_8320(pos).method_26215() || level.method_8320(pos).method_26214((class_1922)level, pos) >= 0.0f;
        return safeDest && level.method_8501(pos, state);
    }

    public static boolean setBlockVarying(class_1937 level, class_2338 pos, class_2248 block, int unified) {
        return PBEffect.setBlockSafe(level, pos, PandorasBoxHelper.getRandomBlockState(level.field_9229, block, unified));
    }

    public static boolean setBlockVaryingUnsafeSrc(class_1937 level, class_2338 pos, class_2248 block, int unified) {
        return PBEffect.setBlockUnsafeSrc(level, pos, PandorasBoxHelper.getRandomBlockState(level.field_9229, block, unified));
    }

    public static class_1657 getRandomNearbyPlayer(class_1937 level, PandorasBoxEntity box) {
        List players = level.method_18467(class_1657.class, box.method_5829().method_1012(30.0, 30.0, 30.0));
        if (players.isEmpty()) {
            return null;
        }
        return (class_1657)players.get(box.method_59922().method_43048(players.size()));
    }

    public static class_1657 getPlayer(class_1937 level, PandorasBoxEntity box) {
        class_1657 player = box.getBoxOwner();
        return player == null ? PBEffect.getRandomNearbyPlayer(level, box) : player;
    }

    @SafeVarargs
    public static boolean isBlockAnyOf(@NotNull class_2248 block, Either<class_2248, class_6862<class_2248>> ... blocks) {
        for (Either<class_2248, class_6862<class_2248>> match : blocks) {
            class_2248 other = match.left().orElse(null);
            class_6862 tag = match.right().orElse(null);
            if (block == other) {
                return true;
            }
            if (tag == null || !block.method_9564().method_26164(tag)) continue;
            return true;
        }
        return false;
    }

    public static class_1297 lazilySpawnEntity(class_1937 level, PandorasBoxEntity box, class_5819 random, String entityID, float chance, class_2338 pos) {
        if (random.method_43057() < chance && !level.method_8608()) {
            return SpawnEntityIDListEffect.createEntity(level, box, random, entityID, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        }
        return null;
    }

    public static class_1297 lazilySpawnFlyingEntity(class_1937 level, PandorasBoxEntity box, class_5819 random, String entityID, float chance, class_2338 pos) {
        class_1297 entity = PBEffect.lazilySpawnEntity(level, box, random, entityID, chance, pos);
        if (entity != null) {
            level.method_8649(entity);
        }
        return entity;
    }

    public static boolean canSpawnEntity(class_1937 level, class_2680 block, class_2338 pos, class_1297 entity) {
        if (entity == null) {
            return false;
        }
        if (level.method_8608()) {
            return false;
        }
        if (block.method_26193() > 0) {
            return false;
        }
        if (level.method_8515(pos.method_10074(), entity) && !level.method_8608()) {
            level.method_8649(entity);
            return true;
        }
        return false;
    }

    public static boolean canSpawnFlyingEntity(class_1937 level, class_2680 block, class_2338 pos) {
        if (level.method_8608()) {
            return false;
        }
        return block.method_26193() <= 0 && level.method_8320(pos.method_10074()).method_26193() <= 0 && level.method_8320(pos.method_10087(2)).method_26193() <= 0;
    }

    public static void combinedEffectDuration(class_1309 entity, class_1293[] mobEffects) {
        for (class_1293 effectInstance : mobEffects) {
            class_1293 prevEffect;
            if (effectInstance == null || !entity.method_6049(effectInstance)) continue;
            if (entity.method_6059(effectInstance.method_5579()) && (prevEffect = entity.method_6112(effectInstance.method_5579())) != null && prevEffect.method_5578() == effectInstance.method_5578()) {
                int duration = prevEffect.method_5584() + effectInstance.method_5584();
                class_1293 combined = new class_1293(effectInstance.method_5579(), duration, effectInstance.method_5578(), effectInstance.method_5591(), effectInstance.method_5581());
                entity.method_6092(combined);
            }
            entity.method_6092(effectInstance);
        }
    }

    public abstract void doTick(PandorasBoxEntity var1, class_243 var2, int var3);

    public abstract boolean isDone(int var1);

    public abstract boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity var1);

    public abstract int getTicksExistedForEffect(PBEffect var1, int var2);

    @NotNull
    public abstract MapCodec<? extends PBEffect> codec();
}

