/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.entity;

import com.mojang.serialization.MapCodec;
import ivorius.pandorasbox.effects.entity.EntityEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.mods.PsychedelicraftHooks;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record DrugEntityEffect(List<DrugInfluence> drugs) implements EntityEffect
{
    public static final MapCodec<DrugEntityEffect> CODEC = DrugInfluence.LIST_CODEC.fieldOf("drugs").xmap(DrugEntityEffect::new, DrugEntityEffect::drugs);

    @Override
    public void affectEntityServer(class_3218 serverLevel, PandorasBoxEntity box, class_5819 random, class_1309 entity, double newRatio, double prevRatio, double strength) {
        for (DrugInfluence effect : this.drugs) {
            float prevStrength = (float)(prevRatio * strength * effect.getTargetInfluence());
            float newStrength = (float)(newRatio * strength * effect.getTargetInfluence());
            float drugStrength = newStrength - prevStrength;
            if (!(drugStrength > 0.0f)) continue;
            PsychedelicraftHooks.addDrugValue(entity, effect, drugStrength);
        }
    }

    @Override
    @NotNull
    public MapCodec<? extends EntityEffect> codec() {
        return CODEC;
    }
}

