/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.generate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.generate.GenerateEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface GenerateByGeneratorEffect<T>
extends GenerateEffect {
    @Override
    default public void generateOnBlock(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, int pass, class_2338 pos, double range, double ratio, int unifiedSeed) {
        if (level instanceof class_3218) {
            class_3218 serverWorld = (class_3218)level;
            if (random.method_43058() < this.chancePerBlock()) {
                class_2680 blockState = level.method_8320(pos);
                class_2338 posBelow = pos.method_10074();
                class_2680 blockBelowState = level.method_8320(posBelow);
                if (blockState.method_26215() && (!this.requiresSolidGround() || blockBelowState.method_26212((class_1922)level, posBelow))) {
                    T generator = this.getRandomGenerator(this.generators(), this.generatorFlags(), random);
                    this.generateGenerator(generator, serverWorld, random, pos);
                }
            }
        }
    }

    public void generateGenerator(T var1, class_3218 var2, class_5819 var3, class_2338 var4);

    public boolean requiresSolidGround();

    public double chancePerBlock();

    public int generatorFlags();

    public List<T> generators();

    default public T getRandomGenerator(List<T> generators, int flags, class_5819 random) {
        int totalNumber = 0;
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            ++totalNumber;
        }
        int chosenGen = random.method_43048(totalNumber);
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (chosenGen == 0) {
                return generators.get(i);
            }
            --chosenGen;
        }
        return null;
    }

    public static <A extends GenerateByGeneratorEffect<T>, T> MapCodec<A> prepareCodec(Function<RecordCodecBuilder.Instance<A>, App<RecordCodecBuilder.Mu<A>, List<T>>> func, Function4<Boolean, Double, Integer, List<T>, A> constructor) {
        return RecordCodecBuilder.mapCodec(aInstance -> aInstance.group((App)Codec.BOOL.fieldOf("requires_solid_ground").forGetter(GenerateByGeneratorEffect::requiresSolidGround), (App)Codec.DOUBLE.fieldOf("chance_per_block").forGetter(GenerateByGeneratorEffect::chancePerBlock), (App)Codec.INT.fieldOf("generator_flags").forGetter(GenerateByGeneratorEffect::generatorFlags), (App)func.apply((RecordCodecBuilder.Instance)aInstance)).apply((Applicative)aInstance, constructor));
    }
}

