/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.mods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBECDrugEntities;
import ivorius.pandorasbox.effects.entity.DrugEntityEffect;
import ivorius.pandorasbox.init.Init;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import java.util.Optional;
import net.atlas.atlascore.util.Codecs;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5699;
import net.minecraft.class_6880;

public class PsychedelicraftHooks {
    public static void register() {
        Init.registerEntityEffectType(DrugEntityEffect.CODEC, "drug_entities");
        Init.registerBoxEffectCreatorType(PBECDrugEntities.CODEC, "drug_entities");
    }

    public static void addDrugValue(class_1309 livingEntity, DrugInfluence drug, float drugStrength) {
        Optional properties = DrugProperties.of((class_1297)livingEntity);
        properties.ifPresent(drugProperties -> drug.addToDrug(drugProperties, (double)drugStrength));
    }

    public record WeightedDrugType(double weight, float minAddValue, float maxAddValue, class_6880<DrugType<?>> drugTypeHolder) implements WeightedSelector.Item
    {
        public static final Codec<WeightedDrugType> DRUG_TYPE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("weight").forGetter(WeightedDrugType::weight), (App)class_5699.field_53754.fieldOf("min_add_value").forGetter(WeightedDrugType::minAddValue), (App)class_5699.field_53754.fieldOf("max_add_value").forGetter(WeightedDrugType::maxAddValue), (App)DrugType.REGISTRY.method_40294().fieldOf("drug_type").forGetter(WeightedDrugType::drugTypeHolder)).apply((Applicative)instance, WeightedDrugType::new)).validate(weightedDrugType -> {
            if (weightedDrugType.minAddValue > weightedDrugType.maxAddValue) {
                return DataResult.error(() -> "Expected drug's minimum add value to be less than or equal to its maximum!");
            }
            return DataResult.success((Object)weightedDrugType);
        });
    }
}

