/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.random;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.random.DValue;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record DExp(double min, double max, double exp) implements DValue
{
    public static final MapCodec<DExp> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min_value").forGetter(DExp::min), (App)Codec.DOUBLE.fieldOf("max_value").forGetter(DExp::max), (App)Codec.DOUBLE.fieldOf("base").forGetter(DExp::exp)).apply((Applicative)instance, DExp::new)).validate(dExp -> {
        if (dExp.min > dExp.max) {
            return DataResult.error(() -> "Constraints for exponential random mismatched, min greater than max!");
        }
        return DataResult.success((Object)dExp);
    });

    @Override
    public double getValue(class_5819 random) {
        return this.min + (Math.pow(this.exp, random.method_43058()) - 1.0) / (this.exp - 1.0) * (this.max - this.min);
    }

    @Override
    @NotNull
    public MapCodec<? extends DValue> codec() {
        return CODEC;
    }
}

