/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderState;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class PandorasBoxRenderer
extends class_897<PandorasBoxEntity, PandorasBoxRenderState>
implements class_3883<PandorasBoxRenderState, PandorasBoxModel> {
    private final class_10442 itemModelResolver;
    public PandorasBoxModel model;
    public class_2960 texture = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.method_32167(PandorasBoxModel.LAYER_LOCATION));
        this.field_4673 = 0.6f;
        this.itemModelResolver = renderManager.method_65566();
    }

    @NotNull
    public PandorasBoxRenderState createRenderState() {
        return new PandorasBoxRenderState();
    }

    public void render(PandorasBoxRenderState renderState, class_4587 poseStack, class_4597 multiBufferSource, int packedLightIn) {
        super.method_3936((class_10017)renderState, poseStack, multiBufferSource, packedLightIn);
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.yRot));
        PBEffect effect = renderState.pbEffect;
        float progress = class_3532.method_15363((float)(((float)renderState.effectTicksExisted + renderState.partialTicks) / (float)effect.getMaxTicksAlive()), (float)0.0f, (float)1.0f);
        float boxScale = renderState.boxScale;
        if (boxScale < 1.0f) {
            poseStack.method_22905(boxScale, boxScale, boxScale);
        }
        float height = 0.0625f * class_3532.method_15374((float)((float)((double)(progress * 4.0f) * Math.PI)));
        int packedOverlay = class_4608.field_21444;
        poseStack.method_46416(0.0f, 0.5f + (height += renderState.renderItem.method_65606() ? 1.0f : -0.25f), 0.0f);
        if (renderState.renderItem.method_65606()) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            this.model.setupAnim(renderState);
        } else {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)((double)(progress * 4.0f) * Math.PI)));
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(renderState.xRot));
        }
        boolean visible = !renderState.field_53333;
        boolean visibleToPlayer = !visible && !renderState.invisibleToPlayer;
        class_1921 renderType = this.getRenderType(visible, visibleToPlayer);
        if (renderType != null) {
            class_4588 consumer = multiBufferSource.getBuffer(renderType);
            if (renderState.renderItem.method_65606()) {
                this.model.method_62100(poseStack, consumer, packedLightIn, packedOverlay, -1);
            } else {
                renderState.renderItem.method_65604(poseStack, multiBufferSource, packedLightIn, packedOverlay);
            }
            if (!effect.isDone(renderState.effectTicksExisted) && renderState.boxDeathTicks < 0) {
                ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>>();
                PBEffectRenderer renderer = PBEffectRenderingRegistry.rendererForEffect(effect);
                if (renderer != null) {
                    renderer.renderBox(this, renderState, effect, renderState.partialTicks, poseStack, multiBufferSource, consumer, packedLightIn, height);
                    List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> renderLayers = renderer.getLayers(this, renderState, effect, this.model, renderState.partialTicks);
                    if (renderLayers != null) {
                        layers.addAll(renderLayers);
                    }
                }
                for (class_3887 class_38872 : layers) {
                    class_38872.method_4199(poseStack, multiBufferSource, packedLightIn, (class_10017)renderState, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22909();
    }

    @Nullable
    protected class_1921 getRenderType(boolean visible, boolean visibleToPlayer) {
        class_2960 resourceLocation = this.texture;
        if (visibleToPlayer) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (visible) {
            return this.model.method_23500(resourceLocation);
        }
        return null;
    }

    public PandorasBoxModel getModel() {
        return this.model;
    }

    public void extractRenderState(PandorasBoxEntity entity, PandorasBoxRenderState entityRenderState, float partialTicks) {
        super.method_62354((class_1297)entity, (class_10017)entityRenderState, partialTicks);
        entityRenderState.xRot = entity.getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f;
        entityRenderState.yRot = entity.method_36454();
        entityRenderState.boxScale = entity.getCurrentScale();
        entityRenderState.partialTicks = partialTicks;
        entityRenderState.effectTicksExisted = entity.getEffectTicksExisted();
        entityRenderState.entityTickCount = entity.field_6012;
        entityRenderState.boxDeathTicks = entity.getDeathTicks();
        entityRenderState.pbEffect = entity.getBoxEffect();
        PandorasBox.logger.info(entity.getRenderItem().toString());
        this.itemModelResolver.method_65595(entityRenderState.renderItem, entity.getRenderItem(), class_811.field_4318, (class_1297)entity);
        entityRenderState.invisibleToPlayer = entity.method_5756((class_1657)class_310.method_1551().field_1724);
    }
}

