/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffects;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public final class PBEffectMeltdown
extends PBEffect {
    public static final MapCodec<PBEffectMeltdown> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(PBEffect.CODEC, () -> new PBEffect[0]).fieldOf("effects").forGetter(PBEffectMeltdown::getEffects), (App)PBNBTHelper.arrayCodec(class_243.field_38277, () -> new class_243[0]).fieldOf("effect_centers").forGetter(PBEffectMeltdown::getEffectCenters), (App)PBNBTHelper.arrayCodec(Codec.INT, () -> new Integer[0]).fieldOf("effect_start_ticks").forGetter(PBEffectMeltdown::getEffectStartTicks), (App)Codec.FLOAT.fieldOf("range").forGetter(PBEffectMeltdown::getRange), (App)Codec.INT.fieldOf("max_ticks_alive").forGetter(PBEffectMeltdown::getMaxTicksAlive)).apply((Applicative)instance, PBEffectMeltdown::new));
    private PBEffect[] effects;
    private class_243[] effectCenters;
    private Integer[] effectStartTicks;
    private final float range;
    private final int maxTicksAlive;
    private Integer indexToOverwrite = null;

    public PBEffectMeltdown(PBEffect[] effects, class_243[] effectCenters, Integer[] effectStartTicks, float range, int maxTicksAlive) {
        this.effects = effects;
        this.effectCenters = effectCenters;
        this.effectStartTicks = effectStartTicks;
        this.range = range;
        this.maxTicksAlive = maxTicksAlive;
    }

    public PBEffectMeltdown(PBEffect firstEffect, float range, int maxTicksAlive) {
        this.effects = new PBEffect[]{firstEffect};
        this.effectCenters = new class_243[]{class_243.field_1353};
        this.effectStartTicks = new Integer[]{0};
        this.range = range;
        this.maxTicksAlive = maxTicksAlive;
    }

    public PBEffect[] getEffects() {
        return this.effects;
    }

    public class_243[] getEffectCenters() {
        return this.effectCenters;
    }

    public Integer[] getEffectStartTicks() {
        return this.effectStartTicks;
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public int getMaxTicksAlive() {
        return this.maxTicksAlive;
    }

    @Override
    public void doTick(PandorasBoxEntity entity, class_243 effectCenter, int ticksAlive) {
        class_243 newEffectCenter;
        double zP;
        double yP;
        double xP;
        class_1937 level = entity.method_37908();
        class_5819 random = entity.method_59922();
        if (ticksAlive == 0) {
            xP = (random.method_43058() - 0.5) * (double)this.range;
            yP = (random.method_43058() - 0.5) * (double)this.range * 0.25;
            zP = (random.method_43058() - 0.5) * (double)this.range;
            this.effectCenters[0] = newEffectCenter = effectCenter.method_1031(xP, yP, zP);
            this.effectStartTicks[0] = 0;
        }
        int rand = random.method_43048(PBEffects.MELTDOWN_CREATORS.length * 16);
        if (!level.field_9236 && rand < PBEffects.MELTDOWN_CREATORS.length) {
            xP = (random.method_43058() - 0.5) * (double)this.range;
            yP = (random.method_43058() - 0.5) * (double)this.range * 0.25;
            zP = (random.method_43058() - 0.5) * (double)this.range;
            newEffectCenter = effectCenter.method_1031(xP, yP, zP);
            PBEffect pbEffect = PBEffects.MELTDOWN_CREATORS[rand].constructEffect(level, newEffectCenter.field_1352, newEffectCenter.field_1351, newEffectCenter.field_1350, random);
            if (this.indexToOverwrite != null) {
                this.effects[this.indexToOverwrite.intValue()] = pbEffect;
                this.effectCenters[this.indexToOverwrite.intValue()] = newEffectCenter;
                this.effectStartTicks[this.indexToOverwrite.intValue()] = ticksAlive;
                this.indexToOverwrite = null;
            } else {
                this.effects = Arrays.copyOf(this.effects, this.effects.length + 1);
                this.effects[this.effects.length - 1] = pbEffect;
                this.effectCenters = Arrays.copyOf(this.effectCenters, this.effectCenters.length + 1);
                this.effectCenters[this.effectCenters.length - 1] = newEffectCenter;
                this.effectStartTicks = Arrays.copyOf(this.effectStartTicks, this.effectStartTicks.length + 1);
                this.effectStartTicks[this.effectStartTicks.length - 1] = ticksAlive;
            }
            entity.setBoxEffect(this);
        }
        for (int i = 0; i < this.effects.length; ++i) {
            double zDif;
            double xDif;
            double zO;
            double xO;
            double zP2;
            double xP2;
            int e;
            int ticksForEffect = ticksAlive - this.effectStartTicks[i];
            if (this.effects[i].isDone(ticksForEffect)) {
                if (this.indexToOverwrite != null) continue;
                this.indexToOverwrite = i;
                continue;
            }
            class_243 currentCenter = this.effectCenters[i];
            this.effects[i].doTick(entity, currentCenter, ticksForEffect);
            if (!level.field_9236) continue;
            if (ticksForEffect == 0) {
                for (e = 0; e < 300; ++e) {
                    double xDir = (random.method_43058() - random.method_43058()) * 2.0;
                    double yDir = random.method_43058() + 2.0;
                    double zDir = (random.method_43058() - random.method_43058()) * 2.0;
                    double xP3 = (random.method_43058() - 0.5) * (double)entity.method_17681();
                    double zP3 = (random.method_43058() - 0.5) * (double)entity.method_17681();
                    level.method_8406((class_2394)class_2398.field_11215, currentCenter.field_1352 + xP3 + xDir, currentCenter.field_1351 + yDir, currentCenter.field_1350 + zP3 + zDir, -xDir, -yDir, -zDir);
                }
                for (e = 0; e < 400; ++e) {
                    xP2 = (random.method_43058() - random.method_43058()) * 0.5;
                    double yP2 = (random.method_43058() - random.method_43058()) * 0.5;
                    zP2 = (random.method_43058() - random.method_43058()) * 0.5;
                    double xDir = random.method_43058() * 3.0 - 1.75;
                    double yDir = random.method_43058() * 3.0 - 1.75;
                    double zDir = random.method_43058() * 3.0 - 1.75;
                    level.method_8406((class_2394)class_2398.field_11214, currentCenter.field_1352 + xP2, currentCenter.field_1351 + yP2, currentCenter.field_1350 + zP2, xDir, yDir, zDir);
                }
            }
            for (e = 0; e < Math.min(ticksForEffect, 45); ++e) {
                xP2 = (random.method_43058() - random.method_43058()) * 0.5;
                double yP3 = (random.method_43058() - random.method_43058()) * 0.5;
                zP2 = (random.method_43058() - random.method_43058()) * 0.5;
                xO = currentCenter.field_1352 + xP2;
                zO = currentCenter.field_1350 + zP2;
                xDif = currentCenter.field_1352 - xO;
                zDif = currentCenter.field_1350 - zO;
                level.method_8406((class_2394)class_2398.field_11251, xO, currentCenter.field_1351 + yP3, zO, random.method_43058() * xDif, random.method_43058() * 0.2, random.method_43058() * zDif);
            }
            for (e = 0; e < Math.min(ticksForEffect, 30); ++e) {
                xP2 = (random.method_43058() - random.method_43058()) * 0.5;
                double yP4 = (random.method_43058() - random.method_43058()) * 0.5;
                zP2 = (random.method_43058() - random.method_43058()) * 0.5;
                xO = currentCenter.field_1352 + xP2;
                zO = currentCenter.field_1350 + zP2;
                xDif = currentCenter.field_1352 - xO;
                zDif = currentCenter.field_1350 - zO;
                level.method_8406((class_2394)class_2398.field_11240, xO, currentCenter.field_1351 + yP4, zO, random.method_43058() * xDif, random.method_43058() * 0.4, random.method_43058() * zDif);
            }
        }
        if (!entity.method_5767() && level.field_9236) {
            for (int e = 0; e < Math.min(ticksAlive, 20); ++e) {
                double xP4 = (random.method_43058() - random.method_43058()) * 0.5;
                double yP5 = (random.method_43058() - random.method_43058()) * 0.5;
                double zP4 = (random.method_43058() - random.method_43058()) * 0.5;
                double xO = entity.method_23317() + xP4;
                double zO = entity.method_23321() + zP4;
                double xDif = entity.method_23317() - xO;
                double zDif = entity.method_23321() - zO;
                level.method_8406((class_2394)class_2398.field_11240, xO, entity.method_23318() + yP5, zO, random.method_43058() * xDif, random.method_43058() * 0.4, random.method_43058() * zDif);
            }
        }
        if (!level.field_9236 && ticksAlive == this.maxTicksAlive - 1) {
            level.method_8537((class_1297)entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), 10.0f, true, class_1937.class_7867.field_40890);
        }
    }

    @Override
    public boolean isDone(int ticksAlive) {
        return ticksAlive >= this.maxTicksAlive;
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        return false;
    }

    @Override
    public int getTicksExistedForEffect(PBEffect identityEffect, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            if (this.effects[i] != identityEffect) continue;
            return ticksAlive - this.effectStartTicks[i];
        }
        return -1;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

