/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderState;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.client.rendering.effects.renderstate.PandoraEffectRenderState;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class PandorasBoxRenderer
extends class_897<PandorasBoxEntity, PandorasBoxRenderState>
implements class_3883<PandorasBoxRenderState, PandorasBoxModel> {
    private final class_10442 itemModelResolver;
    public PandorasBoxModel model;
    public class_2960 texture = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.method_32167(PandorasBoxModel.LAYER_LOCATION));
        this.field_4673 = 0.6f;
        this.itemModelResolver = renderManager.method_65566();
    }

    @NotNull
    public PandorasBoxRenderState createRenderState() {
        return new PandorasBoxRenderState();
    }

    public void submit(PandorasBoxRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        super.method_3936((class_10017)renderState, poseStack, submitNodeCollector, cameraRenderState);
        int packedLightIn = renderState.field_61820;
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.yRot));
        PandoraEffectRenderState pandoraEffectRenderState = renderState.pandoraEffectRenderState;
        float timePassed = ((float)pandoraEffectRenderState.effectTicksExisted + renderState.partialTicks) % (float)pandoraEffectRenderState.maxTicksAlive / (float)pandoraEffectRenderState.maxTicksAlive;
        float boxScale = renderState.boxScale;
        if (boxScale < 1.0f) {
            poseStack.method_22905(boxScale, boxScale, boxScale);
        }
        float height = 0.0625f * class_3532.method_15374((double)((float)((double)(timePassed * 4.0f) * Math.PI)));
        int packedOverlay = class_4608.field_21444;
        poseStack.method_46416(0.0f, 0.5f + (height += renderState.renderItem.method_65606() ? 1.0f : -0.25f), 0.0f);
        if (renderState.renderItem.method_65606()) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        } else {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)((double)(timePassed * 4.0f) * Math.PI)));
        }
        boolean visible = !renderState.field_53333;
        boolean visibleToPlayer = !visible && !renderState.invisibleToPlayer;
        class_1921 renderType = this.getRenderType(visible, visibleToPlayer);
        if (renderType != null) {
            if (renderState.renderItem.method_65606()) {
                submitNodeCollector.method_73489((class_3879)this.model, (Object)renderState, poseStack, renderType, packedLightIn, packedOverlay, renderState.field_61821, null);
            } else {
                renderState.renderItem.method_65604(poseStack, submitNodeCollector, packedLightIn, packedOverlay, renderState.field_61821);
            }
            if (pandoraEffectRenderState.shouldRender(renderState.boxDeathTicks)) {
                ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>>();
                PBEffectRenderer<?, ?> renderer = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
                renderer.renderBox(this, renderState, pandoraEffectRenderState, poseStack, submitNodeCollector, packedLightIn, height, timePassed);
                List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> renderLayers = renderer.getLayers(this, renderState, pandoraEffectRenderState, this.model);
                if (renderLayers != null) {
                    layers.addAll(renderLayers);
                }
                for (class_3887 class_38872 : layers) {
                    class_38872.method_4199(poseStack, submitNodeCollector, packedLightIn, (class_10017)renderState, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22909();
    }

    @Nullable
    protected class_1921 getRenderType(boolean visible, boolean visibleToPlayer) {
        class_2960 identifier = this.texture;
        if (visibleToPlayer) {
            return class_12249.method_75998((class_2960)identifier);
        }
        if (visible) {
            return this.model.method_23500(identifier);
        }
        return null;
    }

    public PandorasBoxModel getModel() {
        return this.model;
    }

    public void extractRenderState(PandorasBoxEntity entity, PandorasBoxRenderState entityRenderState, float partialTicks) {
        super.method_62354((class_1297)entity, (class_10017)entityRenderState, partialTicks);
        entityRenderState.xRot = (float)((double)(entity.getRatioBoxOpen(partialTicks) * 2.0f / 3.0f) * Math.PI);
        entityRenderState.yRot = entity.method_36454();
        entityRenderState.boxScale = entity.getCurrentScale();
        entityRenderState.partialTicks = partialTicks;
        entityRenderState.entityTickCount = entity.field_6012;
        entityRenderState.boxDeathTicks = entity.getDeathTicks();
        this.itemModelResolver.method_65595(entityRenderState.renderItem, entity.getRenderItem(), class_811.field_4318, (class_1297)entity);
        entityRenderState.invisibleToPlayer = entity.method_5756((class_1657)class_310.method_1551().field_1724);
        PBEffectRenderer<?, ?> renderer = PBEffectRenderingRegistry.rendererForID(entity.getBoxEffect().rendererIdentifierForEffect());
        PandoraEffectRenderState renderState = renderer.createRenderState();
        renderer.extractRenderState(entityRenderState, renderState, entity.getBoxEffect(), entity.getEffectTicksExisted());
        entityRenderState.pandoraEffectRenderState = renderState;
    }
}

