/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedSelector;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenRuinedPortal
extends PBEffectGenStructure {
    public static final MapCodec<PBEffectGenRuinedPortal> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectGenRuinedPortal.base(), (App)Codec.INT.fieldOf("max_horizontal").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.length), (App)Codec.INT.fieldOf("max_vertical").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.height), (App)Codec.INT.fieldOf("starting_y").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.startingYOffset), (App)Codec.INT.fieldOf("unified_seed").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.unifiedSeed), (App)Codec.BOOL.fieldOf("grounded").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.grounded), (App)class_2338.field_25064.fieldOf("center").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.center), (App)class_2338.field_25064.xmap(class_2338::method_25503, Function.identity()).fieldOf("current").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.current), (App)PBNBTHelper.arrayCodec(WeightedBlock.BLOCK_CODEC, () -> new WeightedBlock[0]).fieldOf("bricks").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.bricks), (App)RandomizedItemStack.CODEC.listOf().fieldOf("loot").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.loot), (App)class_2350.class_2351.field_25065.fieldOf("axis").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.axis), (App)PBNBTHelper.arrayCodec(Codec.BOOL, () -> new Boolean[0]).fieldOf("used_stairs").forGetter(pbEffectGenRuinedPortal -> pbEffectGenRuinedPortal.usedStairsForTop)).apply((Applicative)instance, PBEffectGenRuinedPortal::new));
    public WeightedBlock[] bricks;
    public List<RandomizedItemStack> loot;
    public class_2350.class_2351 axis;
    public Boolean[] usedStairsForTop = new Boolean[]{false, false};

    public PBEffectGenRuinedPortal(int time, int maxH, int maxY, int startY, int unifiedSeed, WeightedBlock[] brickSet, List<RandomizedItemStack> loot, class_2350.class_2351 axis) {
        super(time, maxH, maxH, maxY, startY, unifiedSeed);
        this.bricks = brickSet;
        this.loot = loot;
        this.axis = axis;
    }

    private PBEffectGenRuinedPortal(int time, int maxH, int maxY, int startY, int unifiedSeed, boolean grounded, class_2338 center, class_2338.class_2339 current, WeightedBlock[] brickSet, List<RandomizedItemStack> loot, class_2350.class_2351 axis, Boolean[] usedStairsForTop) {
        super(time, maxH, maxH, maxY, startY, unifiedSeed, grounded);
        this.center = center;
        this.current = current;
        this.bricks = brickSet;
        this.loot = loot;
        this.axis = axis;
        this.usedStairsForTop = usedStairsForTop;
    }

    @Override
    public boolean buildStructure(class_1937 level, PandorasBoxEntity entity, class_2338 currentPos, class_5819 random, float prevRatio, float newRatio, int length, int width, int height, int originY, int originX, int originZ) {
        int relativeHeight = currentPos.method_10264() - originY;
        double relative = (double)relativeHeight / (double)(--height);
        int portalHAxis = Math.max(class_3532.method_15384((double)((double)length * 0.5)), 2);
        int currentH = currentPos.method_10263();
        int originH = originX;
        int currentOH = currentPos.method_10260();
        int originOH = originZ;
        if (Objects.requireNonNull(this.axis) == class_2350.class_2351.field_11051) {
            currentH = currentPos.method_10260();
            originH = originZ;
            currentOH = currentPos.method_10263();
            originOH = originX;
        }
        if (currentOH == originOH) {
            if ((currentPos.method_10264() == originY || relative == Math.ceil(relative)) && IvMathHelper.isBetweenInclusive(currentH, originH, portalHAxis)) {
                return PBEffectGenRuinedPortal.portalEdges(level, currentPos, random);
            }
            if (currentPos.method_10264() == originY + height + 1 && IvMathHelper.isBetweenInclusive(currentH, originH, portalHAxis + 1)) {
                return this.portalTop(level, currentPos, random, originX, originZ, currentH - originH);
            }
            if (IvMathHelper.isBetweenInclusive(currentPos.method_10264(), class_3532.method_15357((double)((double)originY + (double)height * 0.5)), class_3532.method_15384((double)((double)height * 0.5))) && IvMathHelper.compareOffsets(currentH, originH, portalHAxis)) {
                return PBEffectGenRuinedPortal.portalEdges(level, currentPos, random);
            }
            if (IvMathHelper.isBetweenInclusive(currentPos.method_10264(), class_3532.method_15357((double)((double)originY + (double)height * 0.5)), class_3532.method_15384((double)((double)height * 0.5))) && IvMathHelper.compareOffsets(currentH, originH, portalHAxis + 1) && random.method_43058() > 0.25) {
                class_2248 block = (class_2248)WeightedSelector.selectItem(random, Arrays.asList(this.bricks)).block().comp_349();
                PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, block instanceof class_2510 ? (class_2680)block.method_9564().method_11657((class_2769)class_2510.field_11572, (Comparable)(random.method_43056() ? class_2760.field_12619 : class_2760.field_12617)) : (block instanceof class_2482 ? (class_2680)block.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.values()[level.field_9229.method_43048(class_2771.values().length - 1)]) : block.method_9564()));
                return true;
            }
        } else if (currentPos.method_10264() == originY && IvMathHelper.isBetweenInclusive(currentH, originH, 2) && level.method_8320(currentPos).method_26227().method_15767(class_3486.field_15518) && random.method_43058() > 0.25) {
            PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, ((class_2248)this.bricks[3].block().comp_349()).method_9564());
            return true;
        }
        return false;
    }

    public static boolean portalEdges(class_1937 level, class_2338 currentPos, class_5819 random) {
        if (random.method_43058() > 0.25) {
            if (random.method_43058() > 0.75) {
                PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, class_2246.field_22423.method_9564());
            } else {
                PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, class_2246.field_10540.method_9564());
            }
            return true;
        }
        return false;
    }

    public boolean portalTop(class_1937 level, class_2338 currentPos, class_5819 random, int originX, int originZ, int diff) {
        if (currentPos.method_10263() == originX && currentPos.method_10260() == originZ) {
            if (random.method_43058() > 0.25) {
                PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, class_2246.field_10205.method_9564());
                return true;
            }
        } else if (random.method_43058() > 0.25) {
            boolean isNegative = diff < 0;
            class_2248 block = (class_2248)WeightedSelector.selectItem(random, Arrays.asList(this.bricks)).block().comp_349();
            class_2680 state = block.method_9564();
            if (block instanceof class_2510) {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.method_10169((class_2350.class_2351)this.axis, (class_2350.class_2352)(isNegative ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060)));
                if ((isNegative ? this.usedStairsForTop[0] : this.usedStairsForTop[1]).booleanValue()) {
                    state = ((class_2248)this.bricks[3].block().comp_349()).method_9564();
                }
                if (isNegative) {
                    this.usedStairsForTop[0] = true;
                } else {
                    this.usedStairsForTop[1] = true;
                }
            } else if (!(block instanceof class_2482) && random.method_43056()) {
                state = ((class_2248)this.bricks[3].block().comp_349()).method_9564();
            }
            PBEffectGenRuinedPortal.setBlockSafe(level, currentPos, state);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

