/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import com.mojang.serialization.Codec;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectDuplicateBox;
import ivorius.pandorasbox.init.DataSerializerInit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_6025;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PandorasBoxEntity
extends class_1297
implements class_6025 {
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final class_2940<Integer> BOX_DEATH_TICKS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BOX_WAITING_TIME = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EFFECT_TICKS_EXISTED = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    protected boolean canGenerateMoreEffectsAfterwards;
    protected boolean floatUp;
    private static final class_2940<Float> FLOAT_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<PBEffect> DATA_EFFECT_ID = class_2945.method_12791(PandorasBoxEntity.class, DataSerializerInit.PBEFFECTSERIALIZER);
    private static final class_2940<Optional<class_10583<class_1309>>> DATA_OWNER_UUID = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_55584);
    private static final class_2940<class_1799> DATA_RENDER_ITEM = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13322);
    protected class_243 effectCenter = new class_243(0.0, 0.0, 0.0);

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> p_i50172_1_, class_1937 p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
        this.canGenerateMoreEffectsAfterwards = true;
        this.floatUp = false;
    }

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> entityType, class_1937 level, boolean canGenerateMoreEffectsAfterwards, boolean floatUp) {
        super(entityType, level);
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
        this.floatUp = floatUp;
    }

    public boolean method_30949(@NotNull class_1297 p_241849_1_) {
        return false;
    }

    public class_243 getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(class_243 effectCenter) {
        this.effectCenter = effectCenter;
    }

    public int getBoxWaitingTime() {
        return (Integer)this.field_6011.method_12789(BOX_WAITING_TIME);
    }

    public void setBoxWaitingTime(int amount) {
        this.field_6011.method_12778(BOX_WAITING_TIME, (Object)amount);
    }

    public int getEffectTicksExisted() {
        return (Integer)this.field_6011.method_12789(EFFECT_TICKS_EXISTED);
    }

    public void setEffectTicksExisted(int amount) {
        this.field_6011.method_12778(EFFECT_TICKS_EXISTED, (Object)amount);
    }

    public float getCurrentScale() {
        return ((Float)this.field_6011.method_12789(SCALE_PROGRESS)).floatValue();
    }

    public void setScale(float amount) {
        this.field_6011.method_12778(SCALE_PROGRESS, (Object)Float.valueOf(amount));
    }

    public float getFloatProgress() {
        return ((Float)this.field_6011.method_12789(FLOAT_PROGRESS)).floatValue();
    }

    public void setFloatProgress(float amount) {
        this.field_6011.method_12778(FLOAT_PROGRESS, (Object)Float.valueOf(amount));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BOX_DEATH_TICKS, (Object)-1);
        builder.method_56912(BOX_WAITING_TIME, (Object)-1);
        builder.method_56912(EFFECT_TICKS_EXISTED, (Object)-1);
        builder.method_56912(FLOAT_PROGRESS, (Object)Float.valueOf(-1.0f));
        builder.method_56912(SCALE_PROGRESS, (Object)Float.valueOf(1.0f));
        builder.method_56912(DATA_EFFECT_ID, (Object)new PBEffectDuplicateBox(0));
        builder.method_56912(DATA_OWNER_UUID, Optional.empty());
        builder.method_56912(DATA_RENDER_ITEM, (Object)class_1799.field_8037);
    }

    public int getTicksForEffect(PBEffect identityEffect) {
        if (this.getBoxWaitingTime() == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            return effect.getTicksExistedForEffect(identityEffect, this.getEffectTicksExisted());
        }
        return -2;
    }

    public void method_5773() {
        float scaleInProgress;
        class_1937 level = this.method_73183();
        super.method_5773();
        int timeBoxWaiting = this.getBoxWaitingTime();
        int effectTicksExisted = this.getEffectTicksExisted();
        if (timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (!level.method_8608()) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else if (effect.isDone(effectTicksExisted)) {
                if (!level.method_8608()) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.field_5974.method_43057() < (Double)PandorasBox.CONFIG.boxLongevity.get()) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (effectTicksExisted == 0) {
                    this.setEffectCenter(this.method_73189());
                }
                effect.doTick(this, this.effectCenter, effectTicksExisted);
            }
        }
        if (timeBoxWaiting == 0) {
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            this.method_18799(this.method_18798().method_1021(0.95));
        }
        float floatAwayProgress = this.getFloatProgress();
        if (floatAwayProgress >= 0.0f && floatAwayProgress < 1.0f) {
            float speed = class_3532.method_27285((float)(floatAwayProgress - 0.7f));
            if (this.floatUp) {
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            } else {
                this.method_5724(0.4f, new class_243(-0.0, (double)(speed * 0.02f), (double)-0.02f));
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            }
            this.setFloatProgress(floatAwayProgress += 0.025f);
            if (floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if ((scaleInProgress = this.getCurrentScale()) < 1.0f) {
            scaleInProgress += 0.02f;
        }
        if (scaleInProgress > 1.0f) {
            scaleInProgress = 1.0f;
        }
        this.setScale(scaleInProgress);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0 && !this.method_5767() && level.method_8608()) {
                double zP;
                double yDir;
                double xP;
                int e;
                double yCenter = this.method_23318() + (double)this.method_17682() * 0.5;
                for (e = 0; e < 2; ++e) {
                    xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                    yDir = this.field_5974.method_43058() * 0.1;
                    zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                    level.method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, yCenter, this.method_23321() + zP, 0.0, yDir, 0.0);
                }
                for (e = 0; e < 3; ++e) {
                    double xDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                    yDir = this.field_5974.method_43058() * 4.0 + 2.0;
                    double zDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                    double xP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                    double zP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                    level.method_8406((class_2394)class_2398.field_11215, this.method_23317() + xP2 + xDir, yCenter + yDir, this.method_23321() + zP2 + zDir, -xDir, -yDir, -zDir);
                }
                for (e = 0; e < 4; ++e) {
                    xP = this.field_5974.method_43058() * 16.0 - 8.0;
                    double yP = this.field_5974.method_43058() * 5.0 - 2.0;
                    zP = this.field_5974.method_43058() * 16.0 - 8.0;
                    double xDir = this.field_5974.method_43058() * 2.0 - 1.0;
                    double yDir2 = this.field_5974.method_43058() * 2.0 - 1.0;
                    double zDir = this.field_5974.method_43058() * 2.0 - 1.0;
                    level.method_8406((class_2394)class_2398.field_11214, this.method_23317() + xP, yCenter + yP, this.method_23321() + zP, xDir, yDir2, zDir);
                }
            }
            this.setEffectTicksExisted(++effectTicksExisted);
        } else {
            this.setBoxWaitingTime(--timeBoxWaiting);
        }
        int deathTicks = this.getDeathTicks();
        if (deathTicks >= 0) {
            if (!level.method_8608()) {
                if (deathTicks >= 30) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else {
                for (int e = 0; e < Math.min(deathTicks, 60); ++e) {
                    double xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double yP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    this.method_73183().method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, this.method_23318() + yP, this.method_23321() + zP, 0.0, 0.0, 0.0);
                }
            }
            this.setDeathTicks(deathTicks + 1);
        }
    }

    public void startNewEffect() {
        this.setEffectTicksExisted(0);
        this.setBoxWaitingTime(this.field_5974.method_43048(40));
        this.field_6011.method_12778(DATA_EFFECT_ID, (Object)this.ensureNotNull(PBECRegistry.createRandomEffect(this.method_73183(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true)));
    }

    public void setRenderItem(class_1799 renderItem) {
        this.field_6011.method_12778(DATA_RENDER_ITEM, (Object)renderItem);
    }

    public class_1799 getRenderItem() {
        return (class_1799)this.field_6011.method_12789(DATA_RENDER_ITEM);
    }

    public void setOwner(@Nullable class_1309 entity) {
        this.field_6011.method_12778(DATA_OWNER_UUID, Optional.ofNullable(entity).map(class_10583::method_73299));
    }

    @Nullable
    public class_10583<class_1309> method_66287() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).orElse(null);
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloating() {
        this.setFloatProgress(0.0f);
    }

    public void stopFloating() {
        this.setFloatProgress(-1.0f);
        this.setEffectTicksExisted(0);
    }

    public void beginScalingIn() {
        this.setScale(0.0f);
    }

    public PBEffect getBoxEffect() {
        return (PBEffect)this.field_6011.method_12789(DATA_EFFECT_ID);
    }

    public void setBoxEffect(PBEffect effect) {
        this.field_6011.method_49743(DATA_EFFECT_ID, (Object)this.ensureNotNull(effect), true);
    }

    public PBEffect ensureNotNull(PBEffect input) {
        while (input == null) {
            input = PBECRegistry.createRandomEffect(this.method_73183(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true);
        }
        return input;
    }

    public int getDeathTicks() {
        return (Integer)this.method_5841().method_12789(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.method_5841().method_12778(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.getFloatProgress() >= 0.0f) {
            return class_3532.method_15363((float)((this.getFloatProgress() + partialTicks * 0.025f - 0.5f) * 2.0f), (float)-0.025f, (float)1.0f);
        }
        return 1.0f;
    }

    @NotNull
    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        int data = this.canGenerateMoreEffectsAfterwards ? 1 : 0;
        data <<= 1;
        return new class_2604((class_1297)this, serverEntity, data |= this.floatUp ? 1 : 0);
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.canGenerateMoreEffectsAfterwards = clientboundAddEntityPacket.method_11166() >> 1 == 1;
        this.floatUp = clientboundAddEntityPacket.method_11166() << 31 >>> 31 == 1;
    }

    public void method_5697(@NotNull class_1297 entityIn) {
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        return false;
    }

    protected void method_5749(class_11368 valueInput) {
        this.readBoxData(valueInput);
    }

    protected void method_5652(class_11372 valueOutput) {
        this.writeBoxData(valueOutput);
    }

    public void readBoxData(class_11368 valueInput) {
        this.setBoxEffect((PBEffect)valueInput.method_71426("boxEffect", PBEffect.CODEC.orElseGet(pbEffectError -> PandorasBox.logger.error("Failed to parse box, using fallback. Error: " + pbEffectError), () -> new PBEffectDuplicateBox(0))).get());
        class_10583 entityReference = class_10583.method_66260((class_11368)valueInput, (String)"ownerUUID", (class_1937)this.method_73183());
        if (entityReference != null) {
            this.field_6011.method_12778(DATA_OWNER_UUID, Optional.of(entityReference));
        } else {
            this.field_6011.method_12778(DATA_OWNER_UUID, Optional.empty());
        }
        this.setEffectTicksExisted(valueInput.method_71424("effectTicksExisted", 0));
        this.setBoxWaitingTime(valueInput.method_71424("timeBoxWaiting", 0));
        this.canGenerateMoreEffectsAfterwards = valueInput.method_71433("canGenerateMoreEffectsAfterwards", false);
        this.setFloatProgress(valueInput.method_71423("floatAwayProgress", 0.0f));
        this.floatUp = valueInput.method_71433("floatUp", false);
        this.setScale(valueInput.method_71423("scaleInProgress", 0.0f));
        Optional renderItem = valueInput.method_71426("renderItem", class_1799.field_24671);
        renderItem.ifPresent(this::setRenderItem);
        AtomicBoolean wasError = new AtomicBoolean(false);
        class_243 effectCenter = valueInput.method_71426("effectCenter", class_243.field_38277).orElseGet(() -> {
            wasError.set(true);
            return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
        });
        if (wasError.get()) {
            Optional x = valueInput.method_71426("effectCenterX", (Codec)Codec.DOUBLE);
            Optional y = valueInput.method_71426("effectCenterY", (Codec)Codec.DOUBLE);
            Optional z = valueInput.method_71426("effectCenterZ", (Codec)Codec.DOUBLE);
            if (x.isPresent() && y.isPresent() && z.isPresent()) {
                effectCenter = new class_243(((Double)x.get()).doubleValue(), ((Double)y.get()).doubleValue(), ((Double)z.get()).doubleValue());
            }
        }
        this.setEffectCenter(effectCenter);
    }

    public void writeBoxData(class_11372 valueOutput) {
        valueOutput.method_71477("boxEffect", PBEffect.CODEC, (Object)this.getBoxEffect());
        class_10583<class_1309> entityReference = this.method_66287();
        if (entityReference != null) {
            entityReference.method_66259(valueOutput, "ownerUUID");
        }
        valueOutput.method_71465("effectTicksExisted", this.getEffectTicksExisted());
        valueOutput.method_71465("timeBoxWaiting", this.getBoxWaitingTime());
        valueOutput.method_71472("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        valueOutput.method_71464("floatAwayProgress", this.getFloatProgress());
        valueOutput.method_71472("floatUp", this.floatUp);
        valueOutput.method_71464("scaleInProgress", this.getCurrentScale());
        if (!this.getRenderItem().method_7960()) {
            valueOutput.method_71468("renderItem", class_1799.field_24671, (Object)this.getRenderItem());
        }
        valueOutput.method_71468("effectCenter", class_243.field_38277, (Object)this.effectCenter);
    }
}

