/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.init.MobEffectInit;
import ivorius.pandorasbox.random.ILinear;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import ivorius.pandorasbox.utils.WeightedWithRandomCount;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.pandorasbox.weighted.WeightedSet;
import ivorius.pandorasbox.weighted.WeightedTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4174;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class PandorasBoxHelper {
    public static final List<class_2769<?>> validProperties = List.of(class_2741.field_12518, class_2741.field_12507, class_2741.field_20432, class_2741.field_12485, class_2741.field_12508, class_2741.field_12516, class_2741.field_12499, class_2741.field_12525, class_2741.field_12496, class_2741.field_12548, class_2741.field_12481, class_2741.field_12503);
    public static Object2ObjectLinkedOpenHashMap<EitherArrayList<WeightedBlock, WeightedTag<class_2248>>, Collection<WeightedBlock>> cachedBlockLists = new Object2ObjectLinkedOpenHashMap();
    public static Object2ObjectLinkedOpenHashMap<EitherArrayList<RandomizedItemStack, RandomizedItemTag>, List<RandomizedItemStack>> cachedRandomizedStackLists = new Object2ObjectLinkedOpenHashMap();
    public static List<WeightedEntity> landMobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> mobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> creatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterMobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> tameableCreatures = new ArrayList<WeightedEntity>();
    public static EitherArrayList<RandomizedItemStack, RandomizedItemTag> blocksAndItems = new EitherArrayList();
    public static Multimap<class_2248, class_2769<?>> randomizableBlockProperties = HashMultimap.create();
    public static EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks = new EitherArrayList();
    public static EitherArrayList<RandomizedItemStack, RandomizedItemTag> items = new EitherArrayList();
    public static List<WeightedSet> equipmentSets = new ArrayList<WeightedSet>();
    public static Hashtable<class_1792, Hashtable<Integer, class_1799>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();
    public static EitherArrayList<RandomizedItemStack, RandomizedItemTag> enchantableArmorList = new EitherArrayList();
    public static EitherArrayList<RandomizedItemStack, RandomizedItemTag> enchantableToolList = new EitherArrayList();
    public static EitherArrayList<WeightedBlock, WeightedTag<class_2248>> heavyBlocks = new EitherArrayList();

    public static void addEntities(List<WeightedEntity> list, double weight, int minNumber, int maxNumber, String ... entities) {
        for (String s : entities) {
            list.add(new WeightedEntity(weight, s, minNumber, maxNumber));
        }
    }

    @SafeVarargs
    public static void addBlockTags(double weight, class_6862<class_2248> ... blocks) {
        for (class_6862<class_2248> blockTagKey : blocks) {
            PandorasBoxHelper.blocks.add(Either.right(new WeightedTag<class_2248>(weight, blockTagKey)));
            blockTagKey.method_41008(class_7924.field_41197).ifPresent(itemTag -> blocksAndItems.add(Either.right((Object)new RandomizedItemTag((class_6862<class_1792>)itemTag, new WeightedWithRandomCount(1, Optional.empty(), weight)))));
        }
    }

    public static void addBlocks(double weight, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            PandorasBoxHelper.blocks.add(Either.left((Object)new WeightedBlock(weight, block)));
            class_1792 item = block.method_8389();
            blocksAndItems.add(Either.left((Object)new RandomizedItemStack(item, 1, item.method_7882(), weight)));
        }
    }

    public static void addBlocks(double weight, List<class_2248> blocks) {
        for (class_2248 block : blocks) {
            PandorasBoxHelper.blocks.add(Either.left((Object)new WeightedBlock(weight, block)));
            class_1792 item = block.method_8389();
            blocksAndItems.add(Either.left((Object)new RandomizedItemStack(item, 1, item.method_7882(), weight)));
        }
    }

    public static void addBlocks(EitherArrayList<WeightedBlock, WeightedTag<class_2248>> list, double weight, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            list.add(Either.left((Object)new WeightedBlock(weight, block)));
        }
    }

    public static void addItem(RandomizedItemStack randomizedItemStack) {
        items.add(Either.left((Object)randomizedItemStack));
        blocksAndItems.add(Either.left((Object)randomizedItemStack));
    }

    public static void addTag(RandomizedItemTag randomizedItemTag) {
        items.add(Either.right((Object)randomizedItemTag));
        blocksAndItems.add(Either.right((Object)randomizedItemTag));
    }

    @SafeVarargs
    public static void addTags(double weight, class_6862<class_1792> ... tags) {
        for (class_6862<class_1792> tagKey : tags) {
            PandorasBoxHelper.addTag(new RandomizedItemTag(tagKey, new WeightedWithRandomCount(1, Optional.empty(), weight)));
        }
    }

    @SafeVarargs
    public static void addTagsMinMax(double weight, int min, int max, class_6862<class_1792> ... tags) {
        for (class_6862<class_1792> tagKey : tags) {
            PandorasBoxHelper.addTag(new RandomizedItemTag(tagKey, new WeightedWithRandomCount(min, max, weight)));
        }
    }

    public static void addItems(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof class_1792) {
                class_1792 item = (class_1792)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.method_7882(), weight));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            class_1799 itemStack = (class_1799)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, new WeightedWithRandomCount(1, itemStack.method_7914(), weight)));
        }
    }

    public static void addItemsMinMax(double weight, int min, int max, Object ... items) {
        for (Object object : items) {
            if (object instanceof class_1792) {
                class_1792 item = (class_1792)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, min, max, weight));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            class_1799 itemStack = (class_1799)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, new WeightedWithRandomCount(min, max, weight)));
        }
    }

    public static void addEquipmentSet(double weight, Object ... items) {
        class_1799[] set = new class_1799[items.length];
        for (int i = 0; i < set.length; ++i) {
            class_1799 itemStack;
            Object object = items[i];
            if (object instanceof class_1792) {
                class_1792 item = (class_1792)object;
                set[i] = new class_1799((class_1935)item);
                continue;
            }
            object = items[i];
            if (!(object instanceof class_1799)) continue;
            set[i] = itemStack = (class_1799)object;
        }
        equipmentSets.add(new WeightedSet(weight, set));
    }

    @SafeVarargs
    public static void addPotions(List<WeightedPotion> list, double weight, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration, class_6880<class_1291> ... potions) {
        for (class_6880<class_1291> effect : potions) {
            list.add(new WeightedPotion(weight, (class_6885<class_1291>)class_6885.method_40246((class_6880[])new class_6880[]{effect}), new ILinear(minAmplifier, maxAmplifier), new ILinear(minDuration, maxDuration)));
        }
    }

    @SafeVarargs
    public static void addPotions(List<WeightedPotion> list, double weight, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration, class_6885<class_1291> ... potions) {
        for (class_6885<class_1291> effect : potions) {
            list.add(new WeightedPotion(weight, effect, new ILinear(minAmplifier, maxAmplifier), new ILinear(minDuration, maxDuration)));
        }
    }

    public static void addEnchantableArmor(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof class_1792) {
                class_1792 item = (class_1792)object;
                enchantableArmorList.add(Either.left((Object)new RandomizedItemStack(item, 1, 1, weight)));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            class_1799 itemStack = (class_1799)object;
            enchantableArmorList.add(Either.left((Object)new RandomizedItemStack(itemStack, new WeightedWithRandomCount(1, 1, weight))));
        }
    }

    public static void addEnchantableTools(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof class_1792) {
                class_1792 item = (class_1792)object;
                enchantableToolList.add(Either.left((Object)new RandomizedItemStack(item, 1, 1, weight)));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            class_1799 itemStack = (class_1799)object;
            enchantableToolList.add(Either.left((Object)new RandomizedItemStack(itemStack, new WeightedWithRandomCount(1, 1, weight))));
        }
    }

    public static void addEquipmentForLevel(class_1792 base, int level, class_1799 stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(class_1792 base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof class_1792) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new class_1799((class_1935)((class_1792)items[i])));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (class_1799)items[i]);
        }
    }

    public static void addAllRandomizableBlockProperties() {
        for (class_2248 block : class_7923.field_41175) {
            randomizableBlockProperties.putAll((Object)block, block.method_9564().method_28501().stream().filter(validProperties::contains).toList());
        }
    }

    public static void initialize() {
        cachedBlockLists.clear();
        cachedRandomizedStackLists.clear();
        landMobs.clear();
        mobs.clear();
        creatures.clear();
        waterCreatures.clear();
        waterMobs.clear();
        tameableCreatures.clear();
        blocks.clear();
        randomizableBlockProperties.clear();
        blocksAndItems.clear();
        items.clear();
        equipmentSets.clear();
        equipmentForLevels.clear();
        buffs.clear();
        debuffs.clear();
        enchantableArmorList.clear();
        enchantableToolList.clear();
        heavyBlocks.clear();
        PandorasBoxHelper.addEntities(landMobs, 10.0, 3, 10, "zombie", "drowned");
        PandorasBoxHelper.addEntities(landMobs, 7.5, 3, 10, "husk");
        PandorasBoxHelper.addEntities(landMobs, 10.0, 2, 8, "spider");
        PandorasBoxHelper.addEntities(landMobs, 10.0, 2, 5, "skeleton");
        PandorasBoxHelper.addEntities(landMobs, 10.0, 2, 5, "pillager");
        PandorasBoxHelper.addEntities(landMobs, 7.5, 2, 5, "stray");
        PandorasBoxHelper.addEntities(landMobs, 5.0, 2, 5, "wither_skeleton");
        PandorasBoxHelper.addEntities(landMobs, 10.0, 2, 8, "creeper");
        PandorasBoxHelper.addEntities(landMobs, 6.0, 2, 8, "slime");
        PandorasBoxHelper.addEntities(landMobs, 6.0, 2, 8, "zombified_piglin");
        PandorasBoxHelper.addEntities(landMobs, 6.0, 2, 8, "hoglin");
        PandorasBoxHelper.addEntities(landMobs, 6.0, 2, 6, "enderman");
        PandorasBoxHelper.addEntities(landMobs, 5.0, 2, 4, "cave_spider");
        PandorasBoxHelper.addEntities(landMobs, 5.0, 10, 20, "silverfish");
        PandorasBoxHelper.addEntities(landMobs, 5.0, 2, 6, "magma_cube");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 2, 8, "vindicator");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 2, 4, "zoglin");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 2, 4, "witch");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 10, 20, "endermite");
        PandorasBoxHelper.addEntities(landMobs, 5.0, 2, 6, "pbspecial_angry_wolf");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 2, 5, "pbspecial_charged_creeper");
        PandorasBoxHelper.addEntities(landMobs, 4.0, 2, 5, "breeze");
        PandorasBoxHelper.addEntities(landMobs, 3.0, 1, 1, "evoker");
        PandorasBoxHelper.addEntities(landMobs, 2.0, 2, 3, "piglin_brute");
        PandorasBoxHelper.addEntities(landMobs, 1.0, 1, 1, "ravager");
        mobs.addAll(landMobs);
        PandorasBoxHelper.addEntities(mobs, 1.0, 1, 1, "wither");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "blaze");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "ghast");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "phantom");
        PandorasBoxHelper.addEntities(creatures, 10.0, 3, 10, "pig", "sheep", "cow", "chicken");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "wolf");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "panda");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 2, "polar_bear");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 2, "sniffer");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "fox");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "allay");
        PandorasBoxHelper.addEntities(creatures, 5.0, 4, 10, "bat");
        PandorasBoxHelper.addEntities(creatures, 5.0, 4, 10, "bee");
        PandorasBoxHelper.addEntities(creatures, 6.0, 4, 10, "frog");
        PandorasBoxHelper.addEntities(creatures, 7.0, 6, 20, "rabbit");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "mooshroom");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "snow_golem");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 5, "horse", "donkey", "mule");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 5, "llama");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 6, "ocelot", "cat");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 6, "parrot");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "wandering_trader");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "villager");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "goat");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "piglin");
        PandorasBoxHelper.addEntities(creatures, 3.0, 2, 4, "iron_golem");
        PandorasBoxHelper.addEntities(waterCreatures, 6.0, 6, 20, "squid", "glow_squid", "dolphin", "cod", "salmon", "pufferfish", "turtle", "tropical_fish", "axolotl", "tadpole");
        PandorasBoxHelper.addEntities(waterMobs, 6.0, 3, 10, "drowned");
        PandorasBoxHelper.addEntities(waterMobs, 6.0, 3, 10, "guardian");
        PandorasBoxHelper.addEntities(waterMobs, 5.0, 1, 1, "elder_guardian");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_wolf_tamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_cat_tamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_parrot_tamed");
        PandorasBoxHelper.addBlockTags(40.0, class_3481.field_15471, class_3481.field_15481, class_3481.field_15503, class_3481.field_15475, class_3481.field_15469, class_3481.field_15459, class_3481.field_15465);
        PandorasBoxHelper.addBlocks(15.0, class_2246.field_10135, class_2246.field_10153, class_2246.field_9978);
        PandorasBoxHelper.addBlocks(10.0, class_2246.field_10255, class_2246.field_46282, class_2246.field_10147, class_2246.field_10460, class_2246.field_28892, class_2246.field_28896, class_2246.field_10266, class_2246.field_10104, class_2246.field_10471, class_2246.field_10462);
        PandorasBoxHelper.addBlockTags(10.0, ConventionalBlockTags.COBBLESTONES, class_3481.field_21953, PandorasBox.ALL_TERRACOTTA, ConventionalBlockTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES, ConventionalBlockTags.PLAYER_WORKSTATIONS_FURNACES, class_3481.field_25807, class_3481.field_29822);
        PandorasBoxHelper.addBlockTags(8.0, class_3481.field_15466, ConventionalBlockTags.STONES, class_3481.field_22274, ConventionalBlockTags.QUARTZ_ORES, class_3481.field_29193, class_3481.field_29195, class_3481.field_28991, class_3481.field_28990, class_3481.field_29823, ConventionalBlockTags.CHESTS, ConventionalBlockTags.BARRELS, ConventionalBlockTags.SANDSTONE_BLOCKS, ConventionalBlockTags.VILLAGER_JOB_SITES, class_3481.field_15463, ConventionalBlockTags.CONCRETES, class_3481.field_45063, class_3481.field_15462, class_3481.field_15470, ConventionalBlockTags.GLASS_BLOCKS, ConventionalBlockTags.GLASS_PANES);
        PandorasBoxHelper.addBlocks(0.2, class_2246.field_23261);
        PandorasBoxHelper.addBlockTags(0.2, ConventionalBlockTags.STORAGE_BLOCKS_NETHERITE, ConventionalBlockTags.STORAGE_BLOCKS_DIAMOND, ConventionalBlockTags.STORAGE_BLOCKS_EMERALD, ConventionalBlockTags.STORAGE_BLOCKS_GOLD);
        PandorasBoxHelper.addBlocks(0.3, class_2246.field_10085);
        PandorasBoxHelper.addBlockTags(0.5, ConventionalBlockTags.NETHERITE_SCRAP_ORES, class_3481.field_28989, class_3481.field_29194, class_3481.field_23062);
        PandorasBoxHelper.addBlockTags(1.0, class_3481.field_28988);
        PandorasBoxHelper.addBlocks(2.0, class_2246.field_10375, class_2246.field_10171, class_2246.field_22122, class_2246.field_10258);
        PandorasBoxHelper.addBlockTags(2.0, ConventionalBlockTags.STORAGE_BLOCKS_COAL, ConventionalBlockTags.STORAGE_BLOCKS_COPPER, ConventionalBlockTags.STORAGE_BLOCKS_LAPIS, ConventionalBlockTags.STORAGE_BLOCKS_REDSTONE, ConventionalBlockTags.STORAGE_BLOCKS_SLIME);
        PandorasBoxHelper.addBlocks(5.0, class_2246.field_10081, class_2246.field_10179, class_2246.field_10524, class_2246.field_10174, class_2246.field_10477, class_2246.field_10504, class_2246.field_10009, class_2246.field_46283, class_2246.field_40276);
        PandorasBoxHelper.addBlockTags(5.0, ConventionalBlockTags.STORAGE_BLOCKS_WHEAT, ConventionalBlockTags.STORAGE_BLOCKS_DRIED_KELP, PandorasBox.NORMAL_OBSIDIANS, PandorasBox.CRYING_OBSIDIANS);
        PandorasBoxHelper.addItems(10.0, class_1802.field_8696, class_1802.field_8378, class_1802.field_8145, class_1802.field_8803, class_1802.field_8407, class_1802.field_8810, class_1802.field_22001);
        PandorasBoxHelper.addTags(10.0, class_3489.field_17487, ConventionalItemTags.COPPER_INGOTS, ConventionalItemTags.CROPS, ConventionalItemTags.FERTILIZERS, ConventionalItemTags.EMPTY_BUCKETS, ConventionalItemTags.REDSTONE_DUSTS, ConventionalItemTags.WOODEN_RODS, class_3489.field_44591, ConventionalItemTags.BRICKS, PandorasBox.PANDORA_ITEMS, ConventionalItemTags.GOLD_NUGGETS, ConventionalItemTags.FISHING_ROD_TOOLS, ConventionalItemTags.RAW_MEAT_FOODS, ConventionalItemTags.RAW_FISH_FOODS, ConventionalItemTags.COOKED_MEAT_FOODS, ConventionalItemTags.COOKED_FISH_FOODS, ConventionalItemTags.BREAD_FOODS, ConventionalItemTags.COOKIE_FOODS, ConventionalItemTags.BERRY_FOODS, PandorasBox.PIE_FOODS, ConventionalItemTags.FOOD_POISONING_FOODS, ConventionalItemTags.CANDY_FOODS, ConventionalItemTags.EDIBLE_WHEN_PLACED_FOODS);
        PandorasBoxHelper.addItems(10.0, class_1802.field_20414, class_1802.field_8208, class_1802.field_8279, class_1802.field_8073, class_1802.field_8245, class_1802.field_8308, class_1802.field_20417);
        PandorasBoxHelper.addItems(8.0, class_1802.field_8892, class_1802.field_8074, class_1802.field_8045, class_1802.field_8638);
        PandorasBoxHelper.addTags(8.0, class_3489.field_15536, class_3489.field_16444, ConventionalItemTags.LEATHERS, ConventionalItemTags.MILK_BUCKETS, ConventionalItemTags.LAVA_BUCKETS, ConventionalItemTags.WATER_BUCKETS, ConventionalItemTags.BRUSH_TOOLS, ConventionalItemTags.IGNITER_TOOLS, ConventionalItemTags.SOUP_FOODS, ConventionalItemTags.SLIME_BALLS);
        PandorasBoxHelper.addItems(8.0, class_1802.field_8448, class_1802.field_8864, class_1802.field_8794, class_1802.field_28410, class_1802.field_47830, class_1802.field_16539, class_1802.field_22016, class_1802.field_27070);
        PandorasBoxHelper.addTags(6.0, ConventionalItemTags.IRON_INGOTS, ConventionalItemTags.IRON_NUGGETS, ConventionalItemTags.GLOWSTONE_DUSTS, ConventionalItemTags.AMETHYST_GEMS, ConventionalItemTags.RODS, PandorasBox.BREWING_FUEL);
        PandorasBoxHelper.addItems(6.0, class_1802.field_49098, class_1802.field_8557, class_1802.field_8070, class_1802.field_8449, class_1802.field_8597, class_1802.field_8711, class_1802.field_8135, class_1802.field_8071, class_1802.field_8161, class_1802.field_8614);
        PandorasBoxHelper.addItems(4.0, class_1802.field_8267, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370, class_1802.field_8091, class_1802.field_8647, class_1802.field_8876, class_1802.field_8406, class_1802.field_8167);
        PandorasBoxHelper.addItems(4.0, class_1802.field_8862, class_1802.field_8678, class_1802.field_8416, class_1802.field_8753, class_1802.field_8845, class_1802.field_8335, class_1802.field_8322, class_1802.field_8825, class_1802.field_8303);
        PandorasBoxHelper.addItems(4.0, class_1802.field_8090, class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660, class_1802.field_8371, class_1802.field_8403, class_1802.field_8699, class_1802.field_8475, class_1802.field_8609);
        PandorasBoxHelper.addItems(4.0, class_1802.field_8251, class_1802.field_8719, class_1802.field_8233, class_1802.field_8207);
        PandorasBoxHelper.addItems(3.0, class_1802.field_8255, class_1802.field_47831, class_1802.field_18138, class_1802.field_8578, class_1802.field_8560);
        PandorasBoxHelper.addTagsMinMax(5.0, 1, 1, ConventionalItemTags.CHESTS, ConventionalItemTags.BARRELS);
        PandorasBoxHelper.addTagsMinMax(2.0, 1, 1, class_3489.field_15547);
        PandorasBoxHelper.addItemsMinMax(2.0, 1, 1, class_1802.field_8137, class_1802.field_8668, class_1802.field_8357, class_1802.field_8565, class_1802.field_8657);
        PandorasBoxHelper.addTags(2.0, ConventionalItemTags.MUSIC_DISCS, ConventionalItemTags.DIAMOND_GEMS, ConventionalItemTags.EMERALD_GEMS, ConventionalItemTags.GOLD_INGOTS, ConventionalItemTags.GOLDEN_FOODS, ConventionalItemTags.ENDER_PEARLS, ConventionalItemTags.PRISMARINE_GEMS);
        PandorasBoxHelper.addItems(2.0, class_1802.field_8662, class_1802.field_50140);
        PandorasBoxHelper.addItemsMinMax(0.5, 1, 5, class_1802.field_22021, class_1802.field_38974, class_1802.field_38746, class_1802.field_38747);
        PandorasBoxHelper.addItems(1.0, class_1802.field_8833, class_1802.field_8613);
        PandorasBoxHelper.addItems(2.0, class_1802.field_8807, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8802, class_1802.field_8377, class_1802.field_8250, class_1802.field_8556, class_1802.field_8527);
        PandorasBoxHelper.addItems(0.2, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_22022, class_1802.field_22024, class_1802.field_22023, class_1802.field_22025, class_1802.field_22026);
        PandorasBoxHelper.addTagsMinMax(10.0, 1, 1, ConventionalItemTags.DYES);
        PandorasBoxHelper.addEquipmentSet(10.0, class_1802.field_8267, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370, class_1802.field_8091, class_1802.field_8647, class_1802.field_8876, class_1802.field_8406, class_1802.field_8167);
        PandorasBoxHelper.addEquipmentSet(6.0, class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660, class_1802.field_8371, class_1802.field_8403, class_1802.field_8699, class_1802.field_8475, class_1802.field_8609);
        PandorasBoxHelper.addEquipmentSet(4.0, class_1802.field_8862, class_1802.field_8678, class_1802.field_8416, class_1802.field_8753, class_1802.field_8845, class_1802.field_8335, class_1802.field_8322, class_1802.field_8825, class_1802.field_8303);
        PandorasBoxHelper.addEquipmentSet(2.0, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8802, class_1802.field_8377, class_1802.field_8250, class_1802.field_8556, class_1802.field_8527);
        PandorasBoxHelper.addEquipmentSet(1.0, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_22022, class_1802.field_22024, class_1802.field_22023, class_1802.field_22025, class_1802.field_22026);
        PandorasBoxHelper.addEquipmentSet(6.0, class_1802.field_8399, class_1802.field_8102, new class_1799((class_1935)class_1802.field_8107, 64), class_1802.field_8743, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370, class_1802.field_8475, new class_1799((class_1935)class_1802.field_8279, 8));
        PandorasBoxHelper.addEquipmentSet(6.0, class_1802.field_8743, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370, class_1802.field_8377, class_1802.field_8699, class_1802.field_8475, class_1802.field_8528, new class_1799((class_1935)class_1802.field_8229, 8), new class_1799((class_1935)class_1802.field_8810, 32));
        PandorasBoxHelper.addEquipmentSet(8.0, class_1802.field_8267, class_1802.field_8609, new class_1799((class_1935)class_1802.field_8317, 32), new class_1799((class_1935)class_1802.field_46249, 4), new class_1799((class_1935)class_1802.field_46250, 4), new class_1799((class_1935)class_1802.field_8345, 8), new class_1799((class_1935)class_1802.field_8831, 32), class_1802.field_8705, class_1802.field_8705);
        PandorasBoxHelper.addEquipmentSet(6.0, class_1802.field_8743, class_1802.field_8556, new class_1799((class_1935)class_1802.field_8176, 16));
        PandorasBoxHelper.addEquipmentSet(6.0, class_1802.field_8090, class_1802.field_8660, class_1802.field_8547, class_1802.field_8371, new class_1799((class_1935)class_1802.field_8229, 48));
        PandorasBoxHelper.addEquipmentSet(0.1, class_1802.field_8805, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660, class_1802.field_8547, class_1802.field_49814, class_1802.field_8475, new class_1799((class_1935)class_1802.field_8176, 8));
        class_6885.class_6888 blocks = class_7923.field_41175.method_40260(class_3481.field_15481);
        for (class_6880 block : blocks) {
            if (!(class_5819.method_43047().method_43058() > 0.8)) continue;
            PandorasBoxHelper.addEquipmentSet(6.0, new class_1799((class_1935)class_1802.field_8725, 64), new class_1799((class_1935)block.comp_349(), 16), new class_1799((class_1935)block.comp_349(), 16), new class_1799((class_1935)block.comp_349(), 16), new class_1799((class_1935)class_2246.field_10002, 8), new class_1799((class_1935)class_2246.field_10523, 8));
        }
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8091, class_1802.field_8091, class_1802.field_8845, class_1802.field_8528, class_1802.field_8371, class_1802.field_8802, class_1802.field_22022);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8406, class_1802.field_8406, class_1802.field_8825, class_1802.field_8062, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8647, class_1802.field_8647, class_1802.field_8335, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8876, class_1802.field_8876, class_1802.field_8322, class_1802.field_8776, class_1802.field_8699, class_1802.field_8250, class_1802.field_22023);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8167, class_1802.field_8167, class_1802.field_8303, class_1802.field_8431, class_1802.field_8609, class_1802.field_8527, class_1802.field_22026);
        PandorasBoxHelper.addPotions(buffs, 5.0, 1, 3, 600, 1200, new class_6885[]{class_6885.method_40246((class_6880[])new class_6880[]{class_1294.field_18980, class_1294.field_5924, class_1294.field_50116, class_1294.field_50119, class_1294.field_5916, class_1294.field_5919, class_1294.field_5903})});
        PandorasBoxHelper.addPotions(buffs, 10.0, 0, 3, 1200, 12000, class_1294.field_5924, class_1294.field_5904, class_1294.field_5910, class_1294.field_5913, class_1294.field_5907, class_1294.field_5923, class_1294.field_5918, class_1294.field_5925, class_1294.field_5905, class_1294.field_5898, class_1294.field_5906, class_1294.field_5900, class_1294.field_50121, class_1294.field_50120, class_1294.field_50119, class_1294.field_50118);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 3, 1200, 12000, class_1294.field_5919, class_1294.field_5916, class_1294.field_5909, class_1294.field_5901, class_1294.field_5911, class_1294.field_5903, class_1294.field_5912);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 2, 600, 1200, class_1294.field_5920, class_1294.field_38092);
        PandorasBoxHelper.addPotions(debuffs, 6.0, 0, 3, 600, 900, MobEffectInit.SHRUNK);
        PandorasBoxHelper.addEnchantableArmor(10.0, class_1802.field_8743, class_1802.field_8862, class_1802.field_8805, class_1802.field_8523, class_1802.field_8678, class_1802.field_8058, class_1802.field_8396, class_1802.field_8416, class_1802.field_8348, class_1802.field_8660, class_1802.field_8753, class_1802.field_8285, class_1802.field_8090);
        PandorasBoxHelper.addEnchantableTools(10.0, class_1802.field_8371, class_1802.field_8845, class_1802.field_8802, class_1802.field_8699, class_1802.field_8322, class_1802.field_8250, class_1802.field_8403, class_1802.field_8335, class_1802.field_8377, class_1802.field_8475, class_1802.field_8825, class_1802.field_8556, class_1802.field_8102, class_1802.field_8399, class_1802.field_8547);
        PandorasBoxHelper.addEnchantableArmor(1.0, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030);
        PandorasBoxHelper.addEnchantableTools(1.0, class_1802.field_22022, class_1802.field_22023, class_1802.field_22024, class_1802.field_22025, class_1802.field_22026, class_1802.field_8547);
        PandorasBoxHelper.addEnchantableTools(0.1, class_1802.field_49814);
        PandorasBoxHelper.addBlocks(heavyBlocks, 10.0, class_2246.field_10535);
        PandorasBoxHelper.addAllRandomizableBlockProperties();
    }

    public static int getRandomUnifiedSeed(class_5819 random) {
        return Math.abs(random.method_43054());
    }

    private static <T> T randomElement(Collection<T> collection, class_5819 random) {
        int num = random.method_43048(collection.size());
        int i = 0;
        for (T t : collection) {
            if (i++ != num) continue;
            return t;
        }
        throw new InternalError();
    }

    public static void createRandomFoodProperties(class_1799 stack, class_5819 random) {
        class_4174.class_4175 builder = new class_4174.class_4175();
        if (random.method_43056()) {
            builder.method_19240();
        }
        if (random.method_43058() > 0.7) {
            builder.method_19241();
        }
        builder.method_19238(random.method_39332(1, 10));
        builder.method_19237((float)(0.9 + (random.method_43058() - random.method_43058()) * 0.75));
        if (random.method_43058() > 0.95) {
            List[] posOrNegative = new List[]{buffs, debuffs};
            double probability = random.method_43059();
            List<class_1293> effects = ((WeightedPotion)WeightedSelector.selectItem(random, posOrNegative[random.method_43048(2)])).build(random);
            for (class_1293 effect : effects) {
                builder.method_19239(effect, (float)probability);
            }
        }
        stack.method_57379(class_9334.field_50075, (Object)builder.method_19242());
    }

    public static class_2680 getRandomBlockState(class_5819 rand, class_2248 block, int unified) {
        class_2680 state = block.method_9564();
        Collection randomizableProperties = randomizableBlockProperties.get((Object)block);
        if (randomizableProperties != null) {
            if ((double)rand.method_43057() > 0.25) {
                randomizableProperties.remove(class_2741.field_12508);
            }
            if (unified >= 0) {
                rand = class_5819.method_43049((long)(unified ^ rand.method_43048(256)));
            }
            if (block.method_9595().method_11659().contains(class_2741.field_12514)) {
                state.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true));
            }
            for (class_2769 property : randomizableProperties) {
                state = (class_2680)state.method_11657(property, (Comparable)PandorasBoxHelper.randomElement(property.method_11898(), rand));
            }
        }
        return state;
    }

    public static Collection<WeightedBlock> assembleBlocks(EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks) {
        if (cachedBlockLists.containsKey(blocks)) {
            return (Collection)cachedBlockLists.get(blocks);
        }
        List<WeightedBlock> output = PandorasBoxHelper.assembleCollection(WeightedBlock::block, blockWeightedTag -> {
            ArrayList edit = new ArrayList();
            Iterable ts = class_7923.field_41175.method_40286(blockWeightedTag.tagKey());
            Streams.stream((Iterable)ts).forEach(blockHolder -> edit.add(new WeightedBlock(blockWeightedTag.weight(), (class_6880<class_2248>)blockHolder)));
            return edit;
        }, blocks);
        cachedBlockLists.put(blocks, output);
        return output;
    }

    public static <W extends WeightedSelector.Item, T> List<W> assembleCollection(Function<W, class_6880<T>> heldGetter, Function<WeightedTag<T>, Collection<W>> mapper, EitherArrayList<W, WeightedTag<T>> selection) {
        HashMap select = new HashMap();
        Consumer<WeightedSelector.Item> consumer = w -> {
            if (!select.containsKey(heldGetter.apply(w))) {
                select.put((class_6880)heldGetter.apply(w), w);
            }
        };
        selection.leftSide().forEach(consumer);
        selection.rightSide().stream().map(mapper).forEach(col -> col.forEach(consumer));
        return new ArrayList(select.values());
    }

    public static List<RandomizedItemStack> assembleRandomisedStacks(class_2378<class_1792> itemRegistry, EitherArrayList<RandomizedItemStack, RandomizedItemTag> selection) {
        if (cachedRandomizedStackLists.containsKey(selection)) {
            return (List)cachedRandomizedStackLists.get(selection);
        }
        HashMap select = new HashMap();
        Consumer<RandomizedItemStack> consumer = randomizedItemStack -> {
            if (!select.containsKey(randomizedItemStack.itemStack().method_41409())) {
                select.put(randomizedItemStack.itemStack().method_41409(), randomizedItemStack);
            }
        };
        selection.leftSide().forEach(consumer);
        selection.rightSide().stream().map(randomizedItemTag -> {
            ArrayList edit = new ArrayList();
            Iterable ts = itemRegistry.method_40286(randomizedItemTag.items());
            Streams.stream((Iterable)ts).forEach(itemHolder -> edit.add(new RandomizedItemStack(new class_1799(itemHolder), randomizedItemTag.count().copyWithMaxCountOverride(((class_1792)itemHolder.comp_349()).method_7882()))));
            return edit;
        }).forEach(col -> col.forEach(consumer));
        ArrayList<RandomizedItemStack> output = new ArrayList<RandomizedItemStack>(select.values());
        cachedRandomizedStackLists.put(selection, output);
        return output;
    }

    public static class_2248[] getRandomBlockList(class_5819 rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.method_43057() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.method_43057() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        class_2248[] blocks = new class_2248[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            class_2248 block = (class_2248)WeightedSelector.selectItem(rand, selection).block().comp_349();
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static class_2248 getRandomBlock(class_5819 rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && !randomBlockList.isEmpty()) {
            return (class_2248)WeightedSelector.selectItem(rand, randomBlockList).block().comp_349();
        }
        return (class_2248)WeightedSelector.selectItem(rand, PandorasBoxHelper.assembleBlocks(blocks)).block().comp_349();
    }

    public static WeightedEntity[] getRandomEntityList(class_5819 rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.method_43048(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(class_5819 rand, Collection<WeightedEntity> entityList) {
        return WeightedSelector.selectItem(rand, entityList);
    }

    public static class_1799 getRandomWeaponItemForLevel(class_5819 random, int level) {
        Set<class_1792> itemSet = equipmentForLevels.keySet();
        class_1792[] itemArray = itemSet.toArray(new class_1792[0]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.method_43048(itemArray.length)], level);
    }

    public static class_1799 getWeaponItemForLevel(class_1792 baseItem, int level) {
        Hashtable<Integer, class_1799> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

