/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PandorasBoxRenderer
extends class_897<PandorasBoxEntity>
implements class_3883<PandorasBoxEntity, PandorasBoxModel> {
    public PandorasBoxModel model;
    public class_2960 texture = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.method_32167(PandorasBoxModel.LAYER_LOCATION));
        this.field_4673 = 0.6f;
    }

    public void render(@NotNull PandorasBoxEntity entity, float entityYaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLightIn);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-entityYaw));
        PBEffect effect = entity.getBoxEffect();
        float boxScale = entity.getCurrentScale();
        if (boxScale < 1.0f) {
            poseStack.method_22905(boxScale, boxScale, boxScale);
        }
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        entity.method_36457(entity.getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f);
        int packedOverlay = class_4608.field_21444;
        this.model.setupAnim(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
        boolean visible = !entity.method_5767();
        boolean visibleToPlayer = !visible && !entity.method_5756((class_1657)class_310.method_1551().field_1724);
        class_1921 renderType = this.getRenderType(entity, visible, visibleToPlayer);
        if (renderType != null) {
            class_4588 consumer = multiBufferSource.getBuffer(renderType);
            this.model.method_2828(poseStack, consumer, packedLightIn, packedOverlay, -1);
            if (!effect.isDone(entity.getEffectTicksExisted()) && entity.getDeathTicks() < 0) {
                ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>>();
                PBEffectRenderer renderer = PBEffectRenderingRegistry.rendererForEffect(effect);
                if (renderer != null) {
                    renderer.renderBox(this, entity, effect, partialTicks, poseStack, multiBufferSource, consumer, packedLightIn);
                    List<class_3887<PandorasBoxEntity, PandorasBoxModel>> renderLayers = renderer.getLayers(this, entity, effect, this.model, partialTicks);
                    if (renderLayers != null) {
                        layers.addAll(renderLayers);
                    }
                }
                for (class_3887 class_38872 : layers) {
                    class_38872.method_4199(poseStack, multiBufferSource, packedLightIn, (class_1297)entity, 0.0f, 0.0f, partialTicks, partialTicks, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22909();
    }

    @Nullable
    protected class_1921 getRenderType(PandorasBoxEntity pandorasBox, boolean visible, boolean visibleToPlayer) {
        class_2960 resourceLocation = this.getTextureLocation(pandorasBox);
        if (visibleToPlayer) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (visible) {
            return this.model.method_23500(resourceLocation);
        }
        return null;
    }

    public PandorasBoxModel getModel() {
        return this.model;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull PandorasBoxEntity var1) {
        return this.texture;
    }
}

