/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering.effects;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderer;
import ivorius.pandorasbox.client.rendering.effects.IvRenderHelper;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffectMeltdown;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public class PBEffectRendererMeltdown
implements PBEffectRenderer<PBEffectMeltdown> {
    public class_2960 meltdownTexture1 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_1.png");
    public class_2960 meltdownTexture2 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_2.png");
    public class_2960 meltdownTexture3 = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box_unstable_3.png");

    @Override
    public void renderBox(PandorasBoxRenderer renderer, PandorasBoxEntity entity, PBEffectMeltdown effect, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource, class_4588 consumer, int packedLightIn) {
        int lightColor = 0xFF6611;
        float timePassed = Math.min((float)entity.getEffectTicksExisted() / (float)effect.getMaxTicksAlive(), 1.0f);
        if ((double)timePassed >= 0.8) {
            timePassed *= timePassed;
            timePassed *= timePassed;
            timePassed *= timePassed * 0.5f;
            float scale = timePassed * 0.3f * effect.getRange() * 0.3f;
            IvRenderHelper.renderLights((float)entity.field_6012 + partialTicks, scale, lightColor, timePassed * 255.0f, 10, poseStack, multiBufferSource);
        }
        Arrays.stream(effect.getEffects()).toList().forEach(pbEffect -> {
            PBEffectRenderer renderer1 = PBEffectRenderingRegistry.rendererForEffect(pbEffect);
            if (renderer1 != null && !pbEffect.isDone(entity.getEffectTicksExisted())) {
                renderer1.renderBox(renderer, entity, pbEffect, partialTicks, poseStack, multiBufferSource, consumer, packedLightIn);
            }
        });
        timePassed = Math.min((float)entity.getEffectTicksExisted() / (float)effect.getMaxTicksAlive(), 1.0f);
        class_4588 newConsumer = multiBufferSource.getBuffer(class_1921.method_23689((class_2960)this.getTextureForProgress(timePassed)));
        renderer.model.method_2828(poseStack, newConsumer, packedLightIn, class_4608.field_21444, -1);
    }

    @Override
    public List<class_3887<PandorasBoxEntity, PandorasBoxModel>> getLayers(PandorasBoxRenderer renderer, PandorasBoxEntity entity, PBEffectMeltdown effect, PandorasBoxModel model, float partialTicks) {
        ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>>();
        Arrays.stream(effect.getEffects()).toList().forEach(pbEffect -> {
            List<class_3887<PandorasBoxEntity, PandorasBoxModel>> renderLayers;
            PBEffectRenderer renderer1 = PBEffectRenderingRegistry.rendererForEffect(pbEffect);
            if (renderer1 != null && !pbEffect.isDone(entity.getEffectTicksExisted()) && (renderLayers = renderer1.getLayers(renderer, entity, pbEffect, model, partialTicks)) != null) {
                layers.addAll(renderLayers);
            }
        });
        return layers;
    }

    public class_2960 getTextureForProgress(float progress) {
        return (double)progress >= 0.75 ? this.meltdownTexture3 : ((double)progress >= 0.35 ? this.meltdownTexture2 : this.meltdownTexture1);
    }
}

