/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.generate.SimpleConvertEffect;
import ivorius.pandorasbox.effects.generate.block_mappers.BlockMapper;
import ivorius.pandorasbox.effects.generate.block_mappers.CityMapper;
import ivorius.pandorasbox.effects.generate.block_mappers.SimpleConvertMapper;
import ivorius.pandorasbox.effects.generate.entity_spawners.EntitySpawner;
import ivorius.pandorasbox.effects.generate.entity_spawners.SpawnRandom;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.weighted.WeightedEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public record PBECConvertToCity(DValue range, List<WeightedEntity> entityIDs) implements PBEffectCreator
{
    public static final List<BlockMapper> CITY_MAPPERS;
    public static final List<EntitySpawner> CITY_SPAWNERS;
    public static final Either<class_2248, class_6862<class_2248>>[] CITY_TARGETS;
    public static final MapCodec<PBECConvertToCity> CODEC;

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        double range = this.range.getValue(random);
        int time = class_3532.method_15357((double)((random.method_43058() * 7.0 + 3.0) * range));
        WeightedEntity[] entitySelection = PandorasBoxHelper.getRandomEntityList(random, this.entityIDs);
        ArrayList entities = new ArrayList();
        for (WeightedEntity entity : entitySelection) {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(class_2960.method_12829((String)entity.entityID()));
            entities.add(type);
        }
        ArrayList<BlockMapper> adjMappers = new ArrayList<BlockMapper>(CITY_MAPPERS);
        adjMappers.set(1, new CityMapper(CITY_TARGETS, entities));
        return new PBEffectGenerate(time, range, 3, PandorasBoxHelper.getRandomUnifiedSeed(random), new SimpleConvertEffect(Optional.of(class_1972.field_9451), adjMappers, Collections.emptyList(), CITY_SPAWNERS));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }

    static {
        CITY_TARGETS = new Either[]{Either.right((Object)ConventionalBlockTags.STONES), Either.right((Object)ConventionalBlockTags.COBBLESTONES), Either.right((Object)class_3481.field_25807), Either.right((Object)class_3481.field_22274), Either.right((Object)class_3481.field_21953), Either.right((Object)class_3481.field_29822), Either.right((Object)class_3481.field_15466), Either.right((Object)ConventionalBlockTags.SANDSTONE_BLOCKS), Either.left((Object)class_2246.field_10471)};
        CITY_MAPPERS = new ArrayList<BlockMapper>();
        CITY_MAPPERS.add(new SimpleConvertMapper(new Either[]{Either.right((Object)class_3481.field_20339), Either.right((Object)class_3481.field_29823), Either.right((Object)class_3481.field_21952), Either.left((Object)class_2246.field_10479), Either.left((Object)class_2246.field_10214), Either.left((Object)class_2246.field_10112), Either.left((Object)class_2246.field_10313), Either.left((Object)class_2246.field_10376), Either.left((Object)class_2246.field_10238)}, class_2246.field_10124));
        CITY_MAPPERS.add(new CityMapper(CITY_TARGETS, Collections.emptyList()));
        CITY_MAPPERS.add(new SimpleConvertMapper(new Either[]{Either.right(PandorasBox.ALL_TERRACOTTA)}, class_2246.field_10235));
        CITY_MAPPERS.add(new SimpleConvertMapper(new Either[]{Either.right(PandorasBox.OBSIDIANS), Either.left((Object)class_2246.field_10164), Either.left((Object)class_2246.field_10295)}, class_2246.field_10382));
        CITY_SPAWNERS = new ArrayList<EntitySpawner>();
        CITY_SPAWNERS.add(new SpawnRandom("villager", 0.0025f));
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DValue.CODEC.fieldOf("range").forGetter(PBECConvertToCity::range), (App)WeightedEntity.NO_SPECIAL_CODEC.listOf().fieldOf("entities").forGetter(PBECConvertToCity::entityIDs)).apply((Applicative)instance, PBECConvertToCity::new));
    }
}

