/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.random.IConstant;
import ivorius.pandorasbox.random.ILinear;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.weighted.WeightedEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnArmy(IValue groups, IValue equipLevel, ZValue spawnFromEffectCenter, List<WeightedEntity> entityIDs, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnArmy> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("groups").forGetter(PBECSpawnArmy::groups), (App)IValue.CODEC.optionalFieldOf("equipment_level", (Object)new IConstant(0)).forGetter(PBECSpawnArmy::equipLevel), (App)ZValue.CODEC.fieldOf("spawn_from_effect_center").forGetter(PBECSpawnArmy::spawnFromEffectCenter), (App)WeightedEntity.CODEC.listOf().fieldOf("entities").forGetter(PBECSpawnArmy::entityIDs), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnArmy::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnArmy::valueSpawn)).apply((Applicative)instance, PBECSpawnArmy::new));

    public PBECSpawnArmy(IValue groups, IValue equipLevel, ZValue spawnFromEffectCenter, List<WeightedEntity> entityIDs) {
        this(groups, equipLevel, spawnFromEffectCenter, entityIDs, Optional.of(PBECSpawnEntities.defaultThrow()), Optional.of(PBECSpawnEntities.defaultSpawn()));
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int groups = this.groups.getValue(random);
        WeightedEntity[] entitySelection = PandorasBoxHelper.getRandomEntityList(random, this.entityIDs);
        PBEffect[] effects = new PBEffect[groups * 2];
        int[] delays = new int[effects.length];
        for (int i = 0; i < groups; ++i) {
            WeightedEntity soldierType = entitySelection[random.method_43048(entitySelection.length)];
            String[][] soldiers = new String[new ILinear(soldierType.count().min(), soldierType.count().max().orElse(soldierType.count().min())).getValue(random)][];
            Arrays.fill((Object[])soldiers, new String[]{soldierType.entityID()});
            int equipLevel = this.equipLevel.getValue(random);
            int equipLevelCaptain = 5 + equipLevel;
            int buffLevelCaptain = random.method_43048(5);
            effects[i * 2] = PBECSpawnEntities.constructEffect(random, soldiers, 50, 0, equipLevel, 0, this.spawnFromEffectCenter, this.valueThrow.orElse(null), this.valueSpawn.orElse(null));
            effects[i * 2 + 1] = PBECSpawnEntities.constructEffect(random, new String[][]{{soldierType.entityID()}}, 25, 1, equipLevelCaptain, buffLevelCaptain, this.spawnFromEffectCenter, this.valueThrow.orElse(null), this.valueSpawn.orElse(null));
            delays[i * 2] = i * 50;
            delays[i * 2 + 1] = i * 50 + 25;
        }
        return new PBEffectMulti(effects, delays);
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

