/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.effects.spawn_entities.EntitySpawnConfiguration;
import ivorius.pandorasbox.effects.spawn_entities.SpawnBlocksEffect;
import ivorius.pandorasbox.random.DConstant;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnBlocks(boolean shuffleBlocks, IValue number, IValue ticksPerBlock, ZValue spawnsFromEffectCenter, EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnBlocks> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("shuffle_blocks", (Object)true).forGetter(PBECSpawnBlocks::shuffleBlocks), (App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnBlocks::number), (App)IValue.CODEC.fieldOf("ticks_per_block").forGetter(PBECSpawnBlocks::ticksPerBlock), (App)ZValue.CODEC.fieldOf("spawns_from_effect_center").forGetter(PBECSpawnBlocks::spawnsFromEffectCenter), (App)WeightedBlock.CODEC.fieldOf("blocks").forGetter(PBECSpawnBlocks::blocks), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnBlocks::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnBlocks::valueSpawn)).apply((Applicative)instance, PBECSpawnBlocks::new));

    public PBECSpawnBlocks(IValue number, IValue ticksPerBlock, ZValue spawnsFromEffectCenter, EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) {
        this(true, number, ticksPerBlock, spawnsFromEffectCenter, blocks, valueThrow, valueSpawn);
    }

    public static ValueSpawn defaultShowerSpawn() {
        return new ValueSpawn(new DLinear(5.0, 30.0), new DConstant(150.0));
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        class_2248[] blocks;
        int number = this.number.getValue(random);
        int ticksPerBlock = this.ticksPerBlock.getValue(random);
        Collection<WeightedBlock> movedBlocks = PandorasBoxHelper.assembleBlocks(this.blocks);
        if (this.shuffleBlocks) {
            class_2248[] selection = PandorasBoxHelper.getRandomBlockList(random, movedBlocks);
            blocks = PBECSpawnBlocks.constructBlocks(random, selection, number, true);
        } else {
            int max = 0;
            for (WeightedBlock weightedBlock : movedBlocks) {
                max += (int)weightedBlock.weight();
            }
            class_2248[] selection = new class_2248[max];
            max = 0;
            for (WeightedBlock weightedBlock : movedBlocks) {
                int i = 0;
                while ((double)i < weightedBlock.weight()) {
                    selection[max + i] = (class_2248)weightedBlock.block().comp_349();
                    ++i;
                }
                max += (int)weightedBlock.weight();
            }
            blocks = PBECSpawnBlocks.constructBlocks(random, selection, number, true);
        }
        return PBECSpawnBlocks.constructEffect(random, blocks, number * ticksPerBlock + 1, this.valueThrow.orElse(null), this.valueSpawn.orElse(null), this.spawnsFromEffectCenter.getValue(random));
    }

    public static class_2248[] constructBlocks(class_5819 random, class_2248[] blocks, int number, boolean mixUp) {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (int i = 0; i < number; ++i) {
            list.add(mixUp ? blocks[random.method_43048(blocks.length)] : blocks[i]);
        }
        return list.toArray(new class_2248[0]);
    }

    public static PBEffect constructEffect(class_5819 random, class_2248[] blocks, int time, ValueThrow valueThrow, ValueSpawn valueSpawn, boolean spawnsFromEffectCenter) {
        boolean canSpawn = valueSpawn != null;
        boolean canThrow = valueThrow != null;
        EntitySpawnConfiguration.Builder builder = EntitySpawnConfiguration.builder(!spawnsFromEffectCenter);
        if (canThrow && (!canSpawn || random.method_43056())) {
            return new PBEffectSpawnEntities(time, blocks.length, new SpawnBlocksEffect(blocks, PBECSpawnEntities.setEffectThrow(builder, random, valueThrow).build()));
        }
        if (canSpawn) {
            return new PBEffectSpawnEntities(time, blocks.length, new SpawnBlocksEffect(blocks, PBECSpawnEntities.setEffectSpawn(builder, random, valueSpawn).build()));
        }
        throw new RuntimeException("Both spawnRange and throwStrength are null!");
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

