/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.random.IConstant;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.weighted.WeightedEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnExploMobs(IValue time, IValue number, IValue fuseTime, IValue nameEntities, ZValue spawnFromEffectCenter, List<WeightedEntity> entityIDs, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnExploMobs> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECSpawnExploMobs::time), (App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnExploMobs::number), (App)IValue.CODEC.fieldOf("fuse_time").forGetter(PBECSpawnExploMobs::fuseTime), (App)IValue.CODEC.optionalFieldOf("named_entities", (Object)new IConstant(0)).forGetter(PBECSpawnExploMobs::nameEntities), (App)ZValue.CODEC.fieldOf("spawn_from_effect_center").forGetter(PBECSpawnExploMobs::spawnFromEffectCenter), (App)WeightedEntity.CODEC.listOf().fieldOf("entities").forGetter(PBECSpawnExploMobs::entityIDs), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnExploMobs::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnExploMobs::valueSpawn)).apply((Applicative)instance, PBECSpawnExploMobs::new));

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int time = this.time.getValue(random);
        int number = this.number.getValue(random);
        WeightedEntity entity = PandorasBoxHelper.getRandomEntityFromList(random, this.entityIDs);
        boolean invisible = random.method_43056();
        String[][] entitiesToSpawn = new String[number][];
        for (int i = 0; i < number; ++i) {
            entitiesToSpawn[i] = new String[2];
            entitiesToSpawn[i][0] = (invisible ? "pbspecial_invisible_tnt" : "pbspecial_tnt") + this.fuseTime.getValue(random);
            entitiesToSpawn[i][1] = entity.entityID();
        }
        int nameEntities = this.nameEntities.getValue(random);
        return PBECSpawnEntities.constructEffect(random, entitiesToSpawn, time, nameEntities, 0, 0, this.spawnFromEffectCenter, this.valueThrow.orElse(null), this.valueSpawn.orElse(null));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

