/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.generate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.BlockPositions;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.generate.GenerateEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GenLavaCagesEffect(Optional<class_2248> lavaBlock, class_2248 cageBlock, Optional<class_2248> fillBlock, class_2248 floorBlock, Integer heightOffset, Integer wallDist) implements GenerateEffect
{
    public static final MapCodec<GenLavaCagesEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().optionalFieldOf("lava_block").forGetter(GenLavaCagesEffect::lavaBlock), (App)class_7923.field_41175.method_39673().fieldOf("cage_block").forGetter(GenLavaCagesEffect::cageBlock), (App)class_7923.field_41175.method_39673().optionalFieldOf("fill_block").forGetter(GenLavaCagesEffect::fillBlock), (App)class_7923.field_41175.method_39673().fieldOf("floor_block").forGetter(GenLavaCagesEffect::floorBlock), (App)Codec.INT.fieldOf("height_offset").forGetter(GenLavaCagesEffect::heightOffset), (App)Codec.INT.fieldOf("wall_distance").forGetter(GenLavaCagesEffect::wallDist)).apply((Applicative)instance, GenLavaCagesEffect::new));

    @Override
    public void generateOnBlock(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, int pass, class_2338 pos, double range, double ratio, int unifiedSeed) {
        List outerList;
        if (!(level.method_8608() || level.method_8515(pos, (class_1297)entity) || (outerList = level.method_18467(class_1657.class, BlockPositions.expandToAABB(pos, 3.5, 3.5, 3.5))).isEmpty())) {
            for (class_1657 player : outerList) {
                int playerY = player.method_24515().method_10264();
                int playerX = player.method_24515().method_10263();
                int playerZ = player.method_24515().method_10260();
                int floor = playerY - 1;
                int ceil = playerY + this.heightOffset;
                this.createFloorOrCeil(level, playerX, floor, playerZ, this.wallDist, unifiedSeed);
                this.createFloorOrCeil(level, playerX, ceil, playerZ, this.wallDist, unifiedSeed);
                this.createWalls(level, playerX, playerY, ceil, playerZ, this.wallDist, unifiedSeed);
                this.fill(level, playerX, playerY, ceil, playerZ, this.wallDist, unifiedSeed);
            }
        }
    }

    public void createFloorOrCeil(class_1937 world, int originX, int y, int originZ, int offset, int unifiedSeed) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int z = originZ - offset; z <= originZ + offset; ++z) {
                PBEffect.setBlockVaryingUnsafeSrc(world, new class_2338(x, y, z), this.floorBlock, unifiedSeed);
            }
        }
    }

    public void createWalls(class_1937 world, int originX, int originY, int ceilheight, int originZ, int offset, int unifiedSeed) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    if (x != originX - offset && x != originX + offset && z != originZ - offset && z != originZ + offset) continue;
                    PBEffect.setBlockVarying(world, new class_2338(x, y, z), this.cageBlock, unifiedSeed);
                }
            }
        }
    }

    public void fill(class_1937 world, int originX, int originY, int ceilheight, int originZ, int offset, int unifiedSeed) {
        for (int x = originX - --offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight - 1; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    PBEffect.setBlockVarying(world, new class_2338(x, y, z), this.fillBlock.orElseGet(this.lavaBlock::get), unifiedSeed);
                }
            }
        }
    }

    @Override
    @Nullable
    public class_5321<class_1959> biome() {
        return null;
    }

    @Override
    @NotNull
    public MapCodec<? extends GenerateEffect> codec() {
        return CODEC;
    }
}

