/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectDuplicateBox;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.init.DataSerializerInit;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class PandorasBoxEntity
extends class_1297 {
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final class_2940<Integer> BOX_DEATH_TICKS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BOX_WAITING_TIME = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EFFECT_TICKS_EXISTED = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    protected boolean canGenerateMoreEffectsAfterwards;
    protected boolean floatUp;
    private static final class_2940<Float> FLOAT_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<PBEffect> DATA_EFFECT_ID = class_2945.method_12791(PandorasBoxEntity.class, DataSerializerInit.PBEFFECTSERIALIZER);
    private static final class_2940<Optional<UUID>> DATA_OWNER_UUID = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13313);
    protected class_243 effectCenter = new class_243(0.0, 0.0, 0.0);

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> p_i50172_1_, class_1937 p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
        this.canGenerateMoreEffectsAfterwards = true;
        this.floatUp = false;
    }

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> entityType, class_1937 level, boolean canGenerateMoreEffectsAfterwards, boolean floatUp) {
        super(entityType, level);
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
        this.floatUp = floatUp;
    }

    public boolean method_30949(@NotNull class_1297 p_241849_1_) {
        return false;
    }

    public class_243 getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(double x, double y, double z) {
        this.effectCenter = new class_243(x, y, z);
    }

    public int getBoxWaitingTime() {
        return (Integer)this.field_6011.method_12789(BOX_WAITING_TIME);
    }

    public void setBoxWaitingTime(int amount) {
        this.field_6011.method_12778(BOX_WAITING_TIME, (Object)amount);
    }

    public int getEffectTicksExisted() {
        return (Integer)this.field_6011.method_12789(EFFECT_TICKS_EXISTED);
    }

    public void setEffectTicksExisted(int amount) {
        this.field_6011.method_12778(EFFECT_TICKS_EXISTED, (Object)amount);
    }

    public float getCurrentScale() {
        return ((Float)this.field_6011.method_12789(SCALE_PROGRESS)).floatValue();
    }

    public void setScale(float amount) {
        this.field_6011.method_12778(SCALE_PROGRESS, (Object)Float.valueOf(amount));
    }

    public float getFloatProgress() {
        return ((Float)this.field_6011.method_12789(FLOAT_PROGRESS)).floatValue();
    }

    public void setFloatProgress(float amount) {
        this.field_6011.method_12778(FLOAT_PROGRESS, (Object)Float.valueOf(amount));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BOX_DEATH_TICKS, (Object)-1);
        builder.method_56912(BOX_WAITING_TIME, (Object)-1);
        builder.method_56912(EFFECT_TICKS_EXISTED, (Object)-1);
        builder.method_56912(FLOAT_PROGRESS, (Object)Float.valueOf(-1.0f));
        builder.method_56912(SCALE_PROGRESS, (Object)Float.valueOf(1.0f));
        builder.method_56912(DATA_EFFECT_ID, (Object)new PBEffectDuplicateBox(0));
        builder.method_56912(DATA_OWNER_UUID, Optional.empty());
    }

    public int getTicksForEffect(PBEffect identityEffect) {
        if (this.getBoxWaitingTime() == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            return effect.getTicksExistedForEffect(identityEffect, this.getEffectTicksExisted());
        }
        return -2;
    }

    public void method_5773() {
        int deathTicks;
        float scaleInProgress;
        class_1937 level = this.method_37908();
        super.method_5773();
        int timeBoxWaiting = this.getBoxWaitingTime();
        int effectTicksExisted = this.getEffectTicksExisted();
        if (timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (!level.field_9236) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else if (effect.isDone(effectTicksExisted)) {
                if (!level.field_9236) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.field_5974.method_43057() < (Double)PandorasBox.CONFIG.boxLongevity.get()) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (effectTicksExisted == 0) {
                    this.setEffectCenter(this.method_23317(), this.method_23318(), this.method_23321());
                }
                effect.doTick(this, this.effectCenter, effectTicksExisted);
            }
        }
        if (timeBoxWaiting == 0) {
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            this.method_18799(this.method_18798().method_1021(0.95));
        }
        float floatAwayProgress = this.getFloatProgress();
        if (floatAwayProgress >= 0.0f && floatAwayProgress < 1.0f) {
            float speed = class_3532.method_27285((float)(floatAwayProgress - 0.7f));
            if (this.floatUp) {
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            } else {
                this.method_5724(0.4f, new class_243(-0.0, (double)(speed * 0.02f), (double)-0.02f));
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            }
            this.setFloatProgress(floatAwayProgress += 0.025f);
            if (floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if ((scaleInProgress = this.getCurrentScale()) < 1.0f) {
            scaleInProgress += 0.02f;
        }
        if (scaleInProgress > 1.0f) {
            scaleInProgress = 1.0f;
        }
        this.setScale(scaleInProgress);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0) {
                if (!this.method_5767() && level.method_8608()) {
                    double zP;
                    double yDir;
                    double xP;
                    int e;
                    double yCenter = this.method_23318() + (double)this.method_17682() * 0.5;
                    for (e = 0; e < 2; ++e) {
                        xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                        yDir = this.field_5974.method_43058() * 0.1;
                        zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                        level.method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, yCenter, this.method_23321() + zP, 0.0, yDir, 0.0);
                    }
                    for (e = 0; e < 3; ++e) {
                        double xDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                        yDir = this.field_5974.method_43058() * 4.0 + 2.0;
                        double zDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                        double xP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                        double zP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                        level.method_8406((class_2394)class_2398.field_11215, this.method_23317() + xP2 + xDir, yCenter + yDir, this.method_23321() + zP2 + zDir, -xDir, -yDir, -zDir);
                    }
                    for (e = 0; e < 4; ++e) {
                        xP = this.field_5974.method_43058() * 16.0 - 8.0;
                        double yP = this.field_5974.method_43058() * 5.0 - 2.0;
                        zP = this.field_5974.method_43058() * 16.0 - 8.0;
                        double xDir = this.field_5974.method_43058() * 2.0 - 1.0;
                        double yDir2 = this.field_5974.method_43058() * 2.0 - 1.0;
                        double zDir = this.field_5974.method_43058() * 2.0 - 1.0;
                        level.method_8406((class_2394)class_2398.field_11214, this.method_23317() + xP, yCenter + yP, this.method_23321() + zP, xDir, yDir2, zDir);
                    }
                }
                this.setEffectTicksExisted(++effectTicksExisted);
            }
        } else {
            this.setBoxWaitingTime(--timeBoxWaiting);
        }
        if ((deathTicks = this.getDeathTicks()) >= 0) {
            if (!level.field_9236) {
                if (deathTicks >= 30) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else {
                for (int e = 0; e < Math.min(deathTicks, 60); ++e) {
                    double xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double yP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, this.method_23318() + yP, this.method_23321() + zP, 0.0, 0.0, 0.0);
                }
            }
            this.setDeathTicks(deathTicks + 1);
        }
    }

    public void startNewEffect() {
        this.setEffectTicksExisted(0);
        this.setBoxWaitingTime(this.field_5974.method_43048(40));
        this.field_6011.method_12778(DATA_EFFECT_ID, (Object)this.ensureNotNull(PBECRegistry.createRandomEffect(this.method_37908(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true)));
    }

    public void setBoxOwnerUUID(UUID uuid) {
        if (uuid == null) {
            return;
        }
        this.field_6011.method_12778(DATA_OWNER_UUID, Optional.of(uuid));
    }

    public UUID getBoxOwnerUUID() {
        if (((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).isEmpty()) {
            return null;
        }
        return (UUID)((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).get();
    }

    public void setBoxOwner(class_1657 player) {
        if (player == null) {
            return;
        }
        this.field_6011.method_12778(DATA_OWNER_UUID, Optional.of(player.method_5667()));
    }

    public class_1657 getBoxOwner() {
        if (((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).isEmpty()) {
            return null;
        }
        return this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).get());
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloating() {
        this.setFloatProgress(0.0f);
    }

    public void stopFloating() {
        this.setFloatProgress(-1.0f);
        this.setEffectTicksExisted(0);
    }

    public void beginScalingIn() {
        this.setScale(0.0f);
    }

    public PBEffect getBoxEffect() {
        return (PBEffect)this.field_6011.method_12789(DATA_EFFECT_ID);
    }

    public void setBoxEffect(PBEffect effect) {
        this.field_6011.method_49743(DATA_EFFECT_ID, (Object)this.ensureNotNull(effect), true);
    }

    public PBEffect ensureNotNull(PBEffect input) {
        while (input == null) {
            input = PBECRegistry.createRandomEffect(this.method_37908(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true);
        }
        return input;
    }

    public int getDeathTicks() {
        return (Integer)this.method_5841().method_12789(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.method_5841().method_12778(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.getFloatProgress() >= 0.0f) {
            return class_3532.method_15363((float)((this.getFloatProgress() + partialTicks * 0.025f - 0.5f) * 2.0f), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    @NotNull
    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        int data = this.canGenerateMoreEffectsAfterwards ? 1 : 0;
        data <<= 1;
        return new class_2604((class_1297)this, serverEntity, data |= this.floatUp ? 1 : 0);
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.canGenerateMoreEffectsAfterwards = clientboundAddEntityPacket.method_11166() >> 1 == 1;
        this.floatUp = clientboundAddEntityPacket.method_11166() << 31 >>> 31 == 1;
    }

    public void method_5697(@NotNull class_1297 entityIn) {
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        return false;
    }

    public void method_5749(@NotNull class_2487 compound) {
        this.readBoxData(compound);
    }

    public void method_5652(@NotNull class_2487 compound) {
        this.writeBoxData(compound);
    }

    public void readBoxData(class_2487 compound) {
        this.setBoxEffect(PBEffectRegistry.loadEffect(compound.method_10580("boxEffect"), this.method_56673()));
        if (compound.method_10545("ownerUUID")) {
            this.setBoxOwnerUUID(compound.method_25926("ownerUUID"));
        }
        this.setEffectTicksExisted(compound.method_10550("effectTicksExisted"));
        this.setBoxWaitingTime(compound.method_10550("timeBoxWaiting"));
        this.canGenerateMoreEffectsAfterwards = compound.method_10577("canGenerateMoreEffectsAfterwards");
        this.setFloatProgress(compound.method_10583("floatAwayProgress"));
        this.floatUp = compound.method_10577("floatUp");
        this.setScale(compound.method_10583("scaleInProgress"));
        if (compound.method_10573("effectCenterX", 6) && compound.method_10573("effectCenterY", 6) && compound.method_10573("effectCenterZ", 6)) {
            this.setEffectCenter(compound.method_10574("effectCenterX"), compound.method_10574("effectCenterY"), compound.method_10574("effectCenterZ"));
        } else {
            this.setEffectCenter(this.method_23317(), this.method_23318(), this.method_23321());
        }
    }

    public void writeBoxData(class_2487 compound) {
        compound.method_10566("boxEffect", PBEffectRegistry.writeEffect(this.getBoxEffect(), this.method_56673()));
        UUID uuid = this.getBoxOwnerUUID();
        if (uuid != null) {
            compound.method_25927("ownerUUID", uuid);
        }
        compound.method_10569("effectTicksExisted", this.getEffectTicksExisted());
        compound.method_10569("timeBoxWaiting", this.getBoxWaitingTime());
        compound.method_10556("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        compound.method_10548("floatAwayProgress", this.getFloatProgress());
        compound.method_10556("floatUp", this.floatUp);
        compound.method_10548("scaleInProgress", this.getCurrentScale());
        compound.method_10549("effectCenterX", this.effectCenter.field_1352);
        compound.method_10549("effectCenterY", this.effectCenter.field_1351);
        compound.method_10549("effectCenterZ", this.effectCenter.field_1350);
    }
}

