/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import ivorius.pandorasbox.init.ConventionalBlockTags;
import ivorius.pandorasbox.init.ConventionalItemTags;
import ivorius.pandorasbox.init.PandoraBlockTags;
import ivorius.pandorasbox.init.PandoraItemTags;
import ivorius.pandorasbox.random.ILinear;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import ivorius.pandorasbox.utils.WeightedWithRandomCount;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.pandorasbox.weighted.WeightedTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class PandorasBoxHelper {
    public static final List<class_2769<?>> validProperties = List.of(class_2741.field_12518, class_2741.field_12507, class_2741.field_20432, class_2741.field_12485, class_2741.field_12508, class_2741.field_12516, class_2741.field_12499, class_2741.field_12525, class_2741.field_12496, class_2741.field_12548, class_2741.field_12481, class_2741.field_12503);
    public static Object2ObjectLinkedOpenHashMap<EitherArrayList<WeightedBlock, WeightedTag<class_2248>>, Collection<WeightedBlock>> cachedBlockLists = new Object2ObjectLinkedOpenHashMap();
    public static Object2ObjectLinkedOpenHashMap<EitherArrayList<RandomizedItemStack, RandomizedItemTag>, List<RandomizedItemStack>> cachedRandomizedStackLists = new Object2ObjectLinkedOpenHashMap();
    public static EitherArrayList<RandomizedItemStack, RandomizedItemTag> blocksAndItems = new EitherArrayList();
    public static Multimap<class_2248, class_2769<?>> randomizableBlockProperties = HashMultimap.create();
    public static EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks = new EitherArrayList();
    public static Hashtable<class_1792, Hashtable<Integer, class_1799>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();

    @SafeVarargs
    public static void addBlockTags(double weight, class_6862<class_2248> ... blocks) {
        for (class_6862<class_2248> blockTagKey : blocks) {
            PandorasBoxHelper.blocks.add(Either.right(new WeightedTag<class_2248>(weight, blockTagKey)));
            blocksAndItems.add(Either.right((Object)new RandomizedItemTag((Either<class_6862<class_1792>, class_6862<class_2248>>)Either.right(blockTagKey), new WeightedWithRandomCount(1, Optional.empty(), weight))));
        }
    }

    public static void addBlocks(double weight, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            PandorasBoxHelper.blocks.add(Either.left((Object)new WeightedBlock(weight, block)));
            class_1792 item = block.method_8389();
            blocksAndItems.add(Either.left((Object)new RandomizedItemStack((class_1935)item, 1, item.method_7882(), weight)));
        }
    }

    public static void addTag(RandomizedItemTag randomizedItemTag) {
        blocksAndItems.add(Either.right((Object)randomizedItemTag));
    }

    @SafeVarargs
    public static void addTags(double weight, class_6862<class_1792> ... tags) {
        for (class_6862<class_1792> tagKey : tags) {
            PandorasBoxHelper.addTag(new RandomizedItemTag((Either<class_6862<class_1792>, class_6862<class_2248>>)Either.left(tagKey), new WeightedWithRandomCount(1, Optional.empty(), weight)));
        }
    }

    @SafeVarargs
    public static void addTagsMinMax(double weight, int min, int max, class_6862<class_1792> ... tags) {
        for (class_6862<class_1792> tagKey : tags) {
            PandorasBoxHelper.addTag(new RandomizedItemTag((Either<class_6862<class_1792>, class_6862<class_2248>>)Either.left(tagKey), new WeightedWithRandomCount(min, max, weight)));
        }
    }

    @SafeVarargs
    public static void addPotions(List<WeightedPotion> list, double weight, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration, class_1291 ... potions) {
        for (class_1291 effect : potions) {
            list.add(new WeightedPotion(weight, (class_6885<class_1291>)class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113((Object)effect).orElseThrow()).orElseThrow()}), new ILinear(minAmplifier, maxAmplifier), new ILinear(minDuration, maxDuration)));
        }
    }

    @SafeVarargs
    public static void addPotions(List<WeightedPotion> list, double weight, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration, List<class_1291> ... potions) {
        for (List<class_1291> effect : potions) {
            list.add(new WeightedPotion(weight, (class_6885<class_1291>)class_6885.method_40242(effect.stream().map(mobEffect -> (class_6880.class_6883)class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113(mobEffect).orElseThrow()).orElseThrow()).toList()), new ILinear(minAmplifier, maxAmplifier), new ILinear(minDuration, maxDuration)));
        }
    }

    public static void addEquipmentForLevel(class_1792 base, int level, class_1799 stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(class_1792 base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof class_1792) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new class_1799((class_1935)((class_1792)items[i])));
                continue;
            }
            if (!(object instanceof class_1799)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (class_1799)items[i]);
        }
    }

    public static void addAllRandomizableBlockProperties() {
        for (class_2248 block : class_7923.field_41175) {
            randomizableBlockProperties.putAll((Object)block, block.method_9564().method_28501().stream().filter(validProperties::contains).toList());
        }
    }

    public static void initialize() {
        cachedBlockLists.clear();
        cachedRandomizedStackLists.clear();
        blocks.clear();
        randomizableBlockProperties.clear();
        blocksAndItems.clear();
        equipmentForLevels.clear();
        buffs.clear();
        debuffs.clear();
        PandorasBoxHelper.addBlockTags(30.0, class_3481.field_15471, class_3481.field_15481, class_3481.field_15503, class_3481.field_15475, class_3481.field_15465);
        PandorasBoxHelper.addBlocks(15.0, class_2246.field_10135, class_2246.field_10153, class_2246.field_9978);
        PandorasBoxHelper.addBlocks(10.0, class_2246.field_10255, class_2246.field_10261, class_2246.field_10147, class_2246.field_10460, class_2246.field_28892, class_2246.field_28896, class_2246.field_10266, class_2246.field_10104, class_2246.field_10471, class_2246.field_10462);
        PandorasBoxHelper.addBlockTags(10.0, ConventionalBlockTags.COBBLESTONES, class_3481.field_21953, PandoraBlockTags.ALL_TERRACOTTA, ConventionalBlockTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES, ConventionalBlockTags.PLAYER_WORKSTATIONS_FURNACES, class_3481.field_25807, class_3481.field_29822, class_3481.field_15469, class_3481.field_15459);
        PandorasBoxHelper.addBlockTags(8.0, class_3481.field_15466, ConventionalBlockTags.STONES, class_3481.field_22274, ConventionalBlockTags.QUARTZ_ORES, class_3481.field_29193, class_3481.field_29195, class_3481.field_28991, class_3481.field_28990, class_3481.field_28988, class_3481.field_29823, ConventionalBlockTags.CHESTS, ConventionalBlockTags.BARRELS, ConventionalBlockTags.SANDSTONE_BLOCKS, ConventionalBlockTags.VILLAGER_JOB_SITES, class_3481.field_15463, ConventionalBlockTags.CONCRETES, PandoraBlockTags.CONCRETE_POWDER, class_3481.field_15462, class_3481.field_15470, ConventionalBlockTags.GLASS_BLOCKS, ConventionalBlockTags.GLASS_PANES);
        PandorasBoxHelper.addBlocks(5.0, class_2246.field_10081, class_2246.field_10179, class_2246.field_10524, class_2246.field_10174, class_2246.field_10477, class_2246.field_10504, class_2246.field_10009, class_2246.field_10545, class_2246.field_40276);
        PandorasBoxHelper.addBlockTags(5.0, ConventionalBlockTags.STORAGE_BLOCKS_WHEAT, ConventionalBlockTags.STORAGE_BLOCKS_DRIED_KELP, PandoraBlockTags.NORMAL_OBSIDIANS, PandoraBlockTags.CRYING_OBSIDIANS);
        PandorasBoxHelper.addBlocks(2.0, class_2246.field_23261, class_2246.field_10375, class_2246.field_10171, class_2246.field_22122, class_2246.field_10258);
        PandorasBoxHelper.addBlockTags(2.0, ConventionalBlockTags.STORAGE_BLOCKS_COAL, ConventionalBlockTags.STORAGE_BLOCKS_COPPER, ConventionalBlockTags.STORAGE_BLOCKS_LAPIS, ConventionalBlockTags.STORAGE_BLOCKS_REDSTONE, ConventionalBlockTags.STORAGE_BLOCKS_SLIME);
        PandorasBoxHelper.addBlockTags(0.5, ConventionalBlockTags.NETHERITE_SCRAP_ORES, class_3481.field_28989, class_3481.field_29194, class_3481.field_23062);
        PandorasBoxHelper.addBlockTags(0.2, ConventionalBlockTags.STORAGE_BLOCKS_NETHERITE, ConventionalBlockTags.STORAGE_BLOCKS_DIAMOND, ConventionalBlockTags.STORAGE_BLOCKS_EMERALD, ConventionalBlockTags.STORAGE_BLOCKS_GOLD, ConventionalBlockTags.STORAGE_BLOCKS_IRON);
        PandorasBoxHelper.addTags(10.0, PandoraItemTags.PANDORA_ITEMS_MISC_COMMON);
        PandorasBoxHelper.addTagsMinMax(10.0, 1, 1, ConventionalItemTags.DYES);
        PandorasBoxHelper.addTags(8.0, PandoraItemTags.PANDORA_ITEMS_MISC_UNCOMMON);
        PandorasBoxHelper.addTags(6.0, PandoraItemTags.PANDORA_ITEMS_MISC_RARE);
        PandorasBoxHelper.addTags(4.0, PandoraItemTags.PANDORA_ITEMS_EQUIPMENT_COMMON);
        PandorasBoxHelper.addTags(4.0, PandoraItemTags.PANDORA_ITEMS_MISC_VERY_RARE);
        PandorasBoxHelper.addTags(3.0, PandoraItemTags.PANDORA_ITEMS_EQUIPMENT_UNCOMMON);
        PandorasBoxHelper.addTagsMinMax(5.0, 1, 1, PandoraItemTags.PANDORA_ITEMS_SINGLES_VERY_RARE);
        PandorasBoxHelper.addTagsMinMax(2.0, 1, 1, PandoraItemTags.PANDORA_ITEMS_SINGLES_EPIC);
        PandorasBoxHelper.addTags(2.0, PandoraItemTags.PANDORA_ITEMS_MISC_EPIC);
        PandorasBoxHelper.addTagsMinMax(0.5, 1, 5, PandoraItemTags.PANDORA_ITEMS_LEGENDARY);
        PandorasBoxHelper.addTags(1.0, PandoraItemTags.PANDORA_ITEMS_DRAGON);
        PandorasBoxHelper.addTags(2.0, PandoraItemTags.PANDORA_ITEMS_EQUIPMENT_RARE);
        PandorasBoxHelper.addTags(0.2, PandoraItemTags.PANDORA_ITEMS_EQUIPMENT_VERY_RARE);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8091, class_1802.field_8091, class_1802.field_8845, class_1802.field_8528, class_1802.field_8371, class_1802.field_8802, class_1802.field_22022);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8406, class_1802.field_8406, class_1802.field_8825, class_1802.field_8062, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8647, class_1802.field_8647, class_1802.field_8335, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8876, class_1802.field_8876, class_1802.field_8322, class_1802.field_8776, class_1802.field_8699, class_1802.field_8250, class_1802.field_22023);
        PandorasBoxHelper.addEquipmentLevelsInOrder(class_1802.field_8167, class_1802.field_8167, class_1802.field_8303, class_1802.field_8431, class_1802.field_8609, class_1802.field_8527, class_1802.field_22026);
        PandorasBoxHelper.addPotions(buffs, 5.0, 1, 3, 600, 1200, List.of(class_1294.field_18980, class_1294.field_5924, class_1294.field_5916, class_1294.field_5919, class_1294.field_5903));
        PandorasBoxHelper.addPotions(buffs, 10.0, 0, 3, 1200, 12000, class_1294.field_5924, class_1294.field_5904, class_1294.field_5910, class_1294.field_5913, class_1294.field_5907, class_1294.field_5923, class_1294.field_5918, class_1294.field_5925, class_1294.field_5905, class_1294.field_5898, class_1294.field_5906, class_1294.field_5900);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 3, 1200, 12000, class_1294.field_5919, class_1294.field_5916, class_1294.field_5909, class_1294.field_5901, class_1294.field_5911, class_1294.field_5903, class_1294.field_5912);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 2, 600, 1200, class_1294.field_5920, class_1294.field_38092);
        PandorasBoxHelper.addAllRandomizableBlockProperties();
    }

    public static class_243 getMinPosition(class_238 box) {
        return new class_243(box.field_1323, box.field_1322, box.field_1321);
    }

    public static class_243 getMaxPosition(class_238 box) {
        return new class_243(box.field_1320, box.field_1325, box.field_1324);
    }

    public static int getRandomUnifiedSeed(class_5819 random) {
        return Math.abs(random.method_43054());
    }

    private static <T> T randomElement(Collection<T> collection, class_5819 random) {
        int num = random.method_43048(collection.size());
        int i = 0;
        for (T t : collection) {
            if (i++ != num) continue;
            return t;
        }
        throw new InternalError();
    }

    public static class_2680 getRandomBlockState(class_5819 rand, class_2248 block, int unified) {
        class_2680 state = block.method_9564();
        Collection randomizableProperties = randomizableBlockProperties.get((Object)block);
        if (randomizableProperties != null) {
            if ((double)rand.method_43057() > 0.25) {
                randomizableProperties.remove(class_2741.field_12508);
            }
            if (unified >= 0) {
                rand = class_5819.method_43049((long)(unified ^ rand.method_43048(256)));
            }
            if (block.method_9595().method_11659().contains(class_2741.field_12514)) {
                state.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true));
            }
            for (class_2769 property : randomizableProperties) {
                state = (class_2680)state.method_11657(property, (Comparable)PandorasBoxHelper.randomElement(property.method_11898(), rand));
            }
        }
        return state;
    }

    public static Collection<WeightedBlock> assembleBlocks(EitherArrayList<WeightedBlock, WeightedTag<class_2248>> blocks) {
        if (cachedBlockLists.containsKey(blocks)) {
            return (Collection)cachedBlockLists.get(blocks);
        }
        List<WeightedBlock> output = PandorasBoxHelper.assembleCollection(WeightedBlock::block, blockWeightedTag -> {
            ArrayList edit = new ArrayList();
            Iterable ts = class_7923.field_41175.method_40286(blockWeightedTag.tagKey());
            Streams.stream((Iterable)ts).forEach(blockHolder -> edit.add(new WeightedBlock(blockWeightedTag.weight(), (class_6880<class_2248>)blockHolder)));
            return edit;
        }, blocks);
        cachedBlockLists.put(blocks, output);
        return output;
    }

    public static <W extends WeightedSelector.Item, T> List<W> assembleCollection(Function<W, class_6880<T>> heldGetter, Function<WeightedTag<T>, Collection<W>> mapper, EitherArrayList<W, WeightedTag<T>> selection) {
        HashMap select = new HashMap();
        Consumer<WeightedSelector.Item> consumer = w -> {
            if (!select.containsKey(heldGetter.apply(w))) {
                select.put((class_6880)heldGetter.apply(w), w);
            }
        };
        selection.leftSide().forEach(consumer);
        selection.rightSide().stream().map(mapper).forEach(col -> col.forEach(consumer));
        return new ArrayList(select.values());
    }

    public static List<RandomizedItemStack> assembleRandomisedStacks(class_2378<class_1792> itemRegistry, class_2378<class_2248> blockRegistry, EitherArrayList<RandomizedItemStack, RandomizedItemTag> selection) {
        if (cachedRandomizedStackLists.containsKey(selection)) {
            return (List)cachedRandomizedStackLists.get(selection);
        }
        HashMap select = new HashMap();
        Consumer<RandomizedItemStack> consumer = randomizedItemStack -> {
            if (!select.containsKey(randomizedItemStack.itemStack().method_41409())) {
                select.put(randomizedItemStack.itemStack().method_41409(), randomizedItemStack);
            }
        };
        selection.leftSide().forEach(consumer);
        selection.rightSide().stream().map(randomizedItemTag -> {
            ArrayList edit = new ArrayList();
            List ts = (List)randomizedItemTag.items().map(itemTagKey -> Streams.stream((Iterable)itemRegistry.method_40286(itemTagKey)).map(class_6880::comp_349).toList(), blockTagKey -> Streams.stream((Iterable)blockRegistry.method_40286(blockTagKey)).map(blockHolder -> ((class_2248)blockHolder.comp_349()).method_8389()).toList());
            ts.forEach(item -> {
                class_1799 stack = new class_1799((class_1935)item);
                edit.add(new RandomizedItemStack(stack, randomizedItemTag.count().copyWithMaxCountOverride(stack.method_7914())));
            });
            return edit;
        }).forEach(col -> col.forEach(consumer));
        ArrayList<RandomizedItemStack> output = new ArrayList<RandomizedItemStack>(select.values());
        cachedRandomizedStackLists.put(selection, output);
        return output;
    }

    public static class_2248[] getRandomBlockList(class_5819 rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.method_43057() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.method_43057() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        class_2248[] blocks = new class_2248[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            class_2248 block = (class_2248)WeightedSelector.selectItem(rand, selection).block().comp_349();
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static class_2248 getRandomBlock(class_5819 rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && !randomBlockList.isEmpty()) {
            return (class_2248)WeightedSelector.selectItem(rand, randomBlockList).block().comp_349();
        }
        return (class_2248)WeightedSelector.selectItem(rand, PandorasBoxHelper.assembleBlocks(blocks)).block().comp_349();
    }

    public static WeightedEntity[] getRandomEntityList(class_5819 rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.method_43048(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(class_5819 rand, Collection<WeightedEntity> entityList) {
        return WeightedSelector.selectItem(rand, entityList);
    }

    public static class_1799 getRandomWeaponItemForLevel(class_5819 random, int level) {
        Set<class_1792> itemSet = equipmentForLevels.keySet();
        class_1792[] itemArray = itemSet.toArray(new class_1792[0]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.method_43048(itemArray.length)], level);
    }

    public static class_1799 getWeaponItemForLevel(class_1792 baseItem, int level) {
        Hashtable<Integer, class_1799> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

