/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.client.rendering.effects.renderstate.PandoraEffectRenderState;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PandorasBoxRenderer
extends class_897<PandorasBoxEntity>
implements class_3883<PandorasBoxEntity, PandorasBoxModel> {
    public PandorasBoxModel model;
    public class_2960 texture = new class_2960("pandorasbox", "textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.method_32167(PandorasBoxModel.LAYER_LOCATION));
        this.field_4673 = 0.6f;
    }

    public class_2960 getTextureLocation(PandorasBoxEntity entity) {
        return this.texture;
    }

    public void render(PandorasBoxEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLightIn);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-entityYaw));
        entity.method_36457((float)((double)(entity.getRatioBoxOpen(partialTicks) * 2.0f / 3.0f) * Math.PI));
        PBEffectRenderer<?, ?> effectRenderer = PBEffectRenderingRegistry.rendererForID(entity.getBoxEffect().rendererResourceLocationForEffect());
        PandoraEffectRenderState pandoraEffectRenderState = effectRenderer.createRenderState();
        effectRenderer.extractRenderState(entity, pandoraEffectRenderState, entity.getBoxEffect(), entity.getEffectTicksExisted());
        float timePassed = PandorasBoxRenderer.calculateProgress(pandoraEffectRenderState, partialTicks);
        float boxScale = entity.getCurrentScale();
        if (boxScale < 1.0f) {
            poseStack.method_22905(boxScale, boxScale, boxScale);
        }
        float height = 0.0625f * class_3532.method_15374((float)((float)((double)(timePassed * 4.0f) * Math.PI)));
        int packedOverlay = class_4608.field_21444;
        poseStack.method_46416(0.0f, 0.5f + (height += entity.getRenderItem().method_7960() ? 1.0f : -0.25f), 0.0f);
        if (entity.getRenderItem().method_7960()) {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        } else {
            poseStack.method_22907(class_7833.field_40716.rotation((float)((double)(timePassed * 4.0f) * Math.PI)));
        }
        boolean visible = !entity.method_5767();
        boolean visibleToPlayer = !visible && !entity.method_5756((class_1657)class_310.method_1551().field_1724);
        class_1921 renderType = this.getRenderType(visible, visibleToPlayer);
        if (renderType != null) {
            if (entity.getRenderItem().method_7960()) {
                this.model.setupAnim(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
                class_4588 buffer = class_918.method_23181((class_4597)multiBufferSource, (class_1921)renderType, (boolean)false, (boolean)entity.hasFoil);
                this.model.method_2828(poseStack, buffer, packedLightIn, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                class_310.method_1551().method_1480().method_23178(entity.getRenderItem(), class_811.field_4319, packedLightIn, packedOverlay, poseStack, multiBufferSource, entity.method_37908(), -1);
            }
            if (pandoraEffectRenderState.shouldRender(entity.getDeathTicks())) {
                ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>>();
                effectRenderer.renderBox(this, entity, pandoraEffectRenderState, poseStack, multiBufferSource, packedLightIn, height, timePassed, partialTicks);
                List<class_3887<PandorasBoxEntity, PandorasBoxModel>> renderLayers = effectRenderer.getLayers(this, entity, pandoraEffectRenderState, this.model);
                if (renderLayers != null) {
                    layers.addAll(renderLayers);
                }
                for (class_3887 class_38872 : layers) {
                    class_38872.method_4199(poseStack, multiBufferSource, packedLightIn, (class_1297)entity, 0.0f, 0.0f, partialTicks, partialTicks, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22909();
    }

    @Nullable
    protected class_1921 getRenderType(boolean visible, boolean visibleToPlayer) {
        class_2960 resourceLocation = this.texture;
        if (visibleToPlayer) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (visible) {
            return this.model.method_23500(resourceLocation);
        }
        return null;
    }

    public PandorasBoxModel getModel() {
        return this.model;
    }

    public static float calculateProgress(PandoraEffectRenderState pandoraEffectRenderState, float partialTicks) {
        if (pandoraEffectRenderState.effectTicksExisted == -1) {
            return 0.0f;
        }
        int animTicks = Math.max(pandoraEffectRenderState.maxTicksAlive, 20);
        return ((float)pandoraEffectRenderState.effectTicksExisted + partialTicks) % (float)animTicks / (float)animTicks;
    }
}

