/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering.effects;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderer;
import ivorius.pandorasbox.client.rendering.effects.IvRenderHelper;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.client.rendering.effects.renderstate.MeltdownEffectRenderState;
import ivorius.pandorasbox.client.rendering.effects.renderstate.PandoraEffectRenderState;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMeltdown;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public class PBEffectRendererMeltdown
extends PBEffectRenderer<PBEffectMeltdown, MeltdownEffectRenderState> {
    public class_2960 meltdownTexture1 = new class_2960("pandorasbox", "textures/entity/pandoras_box_unstable_1.png");
    public class_2960 meltdownTexture2 = new class_2960("pandorasbox", "textures/entity/pandoras_box_unstable_2.png");
    public class_2960 meltdownTexture3 = new class_2960("pandorasbox", "textures/entity/pandoras_box_unstable_3.png");

    @Override
    public void renderBox(PandorasBoxRenderer renderer, PandorasBoxEntity pandorasBoxEntity, MeltdownEffectRenderState effectRenderState, class_4587 poseStack, class_4597 multiBufferSource, int packedLightIn, float height, float timePassed, float partialTicks) {
        int lightColor = 0xFF6611;
        if ((double)timePassed >= 0.8) {
            float renderProgress = timePassed;
            renderProgress *= renderProgress;
            renderProgress *= renderProgress;
            renderProgress *= renderProgress * 0.5f;
            float scale = renderProgress * 0.3f * effectRenderState.range * 0.3f;
            IvRenderHelper.renderLights((float)effectRenderState.effectTicksExisted + partialTicks, scale, height, lightColor, renderProgress * 255.0f, 10, poseStack, multiBufferSource);
        }
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            renderer1.renderBox(renderer, pandorasBoxEntity, pandoraEffectRenderState, poseStack, multiBufferSource, packedLightIn, height, PandorasBoxRenderer.calculateProgress(pandoraEffectRenderState, partialTicks), partialTicks);
        });
        if (!pandorasBoxEntity.getRenderItem().method_7960()) {
            return;
        }
        class_4588 newConsumer = multiBufferSource.getBuffer(class_1921.method_23580((class_2960)this.getTextureForProgress(timePassed)));
        renderer.model.method_2828(poseStack, newConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public List<class_3887<PandorasBoxEntity, PandorasBoxModel>> getLayers(PandorasBoxRenderer renderer, PandorasBoxEntity pandorasBoxEntity, MeltdownEffectRenderState effectRenderState, PandorasBoxModel model) {
        ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>>();
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            List<class_3887<PandorasBoxEntity, PandorasBoxModel>> renderLayers = renderer1.getLayers(renderer, pandorasBoxEntity, pandoraEffectRenderState, model);
            if (renderLayers != null) {
                layers.addAll(renderLayers);
            }
        });
        return layers;
    }

    @Override
    public PandoraEffectRenderState createRenderState() {
        return new MeltdownEffectRenderState();
    }

    public class_2960 getTextureForProgress(float progress) {
        return (double)progress >= 0.75 ? this.meltdownTexture3 : ((double)progress >= 0.35 ? this.meltdownTexture2 : this.meltdownTexture1);
    }

    @Override
    public void extractRenderState(PandorasBoxEntity entity, MeltdownEffectRenderState pandoraEffectRenderState, PBEffectMeltdown pandoraEffect, int effectTicksExisted) {
        super.extractRenderState(entity, pandoraEffectRenderState, pandoraEffect, effectTicksExisted);
        pandoraEffectRenderState.range = pandoraEffect.getRange();
        ArrayList<PandoraEffectRenderState> effectRenderStates = new ArrayList<PandoraEffectRenderState>();
        for (PBEffect effect : pandoraEffect.getEffects()) {
            PBEffectRenderer<?, ?> renderer = PBEffectRenderingRegistry.rendererForID(effect.rendererResourceLocationForEffect());
            int ticksExistedForEffect = pandoraEffect.getTicksExistedForEffect(effect, effectTicksExisted);
            if (effect.isDone(ticksExistedForEffect) && !renderer.rendersAfterDone()) continue;
            PandoraEffectRenderState renderState = renderer.createRenderState();
            renderer.extractRenderState(entity, renderState, effect, ticksExistedForEffect);
            effectRenderStates.add(renderState);
        }
        pandoraEffectRenderState.effects = (PandoraEffectRenderState[])effectRenderStates.toArray(PandoraEffectRenderState[]::new);
    }

    @Override
    public boolean rendersAfterDone() {
        return true;
    }
}

