/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering.effects;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.client.rendering.effects.renderstate.MultiEffectRenderState;
import ivorius.pandorasbox.client.rendering.effects.renderstate.PandoraEffectRenderState;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class PBEffectRendererMulti
extends PBEffectRenderer<PBEffectMulti, MultiEffectRenderState> {
    @Override
    public void renderBox(PandorasBoxRenderer renderer, PandorasBoxEntity pandorasBoxEntity, MultiEffectRenderState effectRenderState, class_4587 poseStack, class_4597 multiBufferSource, int packedLightIn, float height, float timePassed, float partialTicks) {
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            renderer1.renderBox(renderer, pandorasBoxEntity, pandoraEffectRenderState, poseStack, multiBufferSource, packedLightIn, height, PandorasBoxRenderer.calculateProgress(pandoraEffectRenderState, partialTicks), partialTicks);
        });
    }

    @Override
    public List<class_3887<PandorasBoxEntity, PandorasBoxModel>> getLayers(PandorasBoxRenderer renderer, PandorasBoxEntity pandorasBoxEntity, MultiEffectRenderState effectRenderState, PandorasBoxModel model) {
        ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxEntity, PandorasBoxModel>>();
        Arrays.stream(effectRenderState.effects).toList().forEach(pandoraEffectRenderState -> {
            PBEffectRenderer<?, ?> renderer1 = PBEffectRenderingRegistry.rendererForEffect(pandoraEffectRenderState);
            List<class_3887<PandorasBoxEntity, PandorasBoxModel>> renderLayers = renderer1.getLayers(renderer, pandorasBoxEntity, pandoraEffectRenderState, model);
            if (renderLayers != null) {
                layers.addAll(renderLayers);
            }
        });
        return layers;
    }

    @Override
    public PandoraEffectRenderState createRenderState() {
        return new MultiEffectRenderState();
    }

    @Override
    public void extractRenderState(PandorasBoxEntity entity, MultiEffectRenderState pandoraEffectRenderState, PBEffectMulti pandoraEffect, int effectTicksExisted) {
        super.extractRenderState(entity, pandoraEffectRenderState, pandoraEffect, effectTicksExisted);
        ArrayList<PandoraEffectRenderState> effectRenderStates = new ArrayList<PandoraEffectRenderState>();
        for (PBEffect effect : pandoraEffect.getEffects()) {
            PBEffectRenderer<?, ?> renderer = PBEffectRenderingRegistry.rendererForID(effect.rendererResourceLocationForEffect());
            int ticksExistedForEffect = pandoraEffect.getTicksExistedForEffect(effect, effectTicksExisted);
            if (effect.isDone(ticksExistedForEffect) && !renderer.rendersAfterDone()) continue;
            PandoraEffectRenderState renderState = renderer.createRenderState();
            renderer.extractRenderState(entity, renderState, effect, ticksExistedForEffect);
            effectRenderStates.add(renderState);
        }
        pandoraEffectRenderState.effects = (PandoraEffectRenderState[])effectRenderStates.toArray(PandoraEffectRenderState[]::new);
    }
}

