/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.effects.entity.BuffEntityEffect;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSelector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1937;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECBuffEntities(IValue time, IValue number, DValue range, float chanceForMoreEffects, List<WeightedPotion> applicablePotions) implements PBEffectCreator
{
    public static final MapCodec<PBECBuffEntities> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("time").forGetter(PBECBuffEntities::time), (App)IValue.CODEC.fieldOf("number").forGetter(PBECBuffEntities::number), (App)DValue.CODEC.fieldOf("range").forGetter(PBECBuffEntities::range), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_for_more_effects").forGetter(PBECBuffEntities::chanceForMoreEffects), (App)WeightedPotion.CODEC.listOf().fieldOf("mob_effects").forGetter(PBECBuffEntities::applicablePotions)).apply((Applicative)instance, PBECBuffEntities::new));

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int number = this.number.getValue(random);
        int time = this.time.getValue(random);
        double range = this.range.getValue(random);
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        for (int i = 0; i < number; ++i) {
            WeightedPotion weightedPotion = WeightedSelector.selectItem(random, this.applicablePotions);
            effects.addAll(weightedPotion.build(random));
        }
        return new PBEffectEntityBased(time, range, new BuffEntityEffect(effects.toArray(new class_1293[0])));
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return this.chanceForMoreEffects;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

