/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.class_1937;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record PBECMulti(PBEffectCreator[] effects, Integer[] delays) implements PBEffectCreator
{
    public static final MapCodec<PBECMulti> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(PBEffectCreator.CODEC, () -> new PBEffectCreator[0]).fieldOf("effects").forGetter(PBECMulti::effects), (App)PBNBTHelper.arrayCodec(class_5699.field_33441, () -> new Integer[0]).fieldOf("delays").forGetter(PBECMulti::delays)).apply((Applicative)instance, PBECMulti::new)), pbecMulti -> {
        if (pbecMulti.effects.length != pbecMulti.delays.length) {
            return DataResult.error(() -> "Misaligned effects and delays in multi-effect creator!");
        }
        return DataResult.success((Object)pbecMulti);
    });

    public static PBECMulti create(Object ... effectsAndDelays) {
        PBECMulti multi = new PBECMulti(new PBEffectCreator[effectsAndDelays.length / 2], new Integer[effectsAndDelays.length / 2]);
        if (effectsAndDelays.length % 2 != 0) {
            throw new IllegalStateException("Each effect must be mapped to a delay!");
        }
        for (int i = 0; i < multi.effects.length; ++i) {
            multi.effects[i] = (PBEffectCreator)effectsAndDelays[i * 2];
            multi.delays[i] = (Integer)effectsAndDelays[i * 2 + 1];
        }
        return multi;
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        PBEffect[] createdEffects = new PBEffect[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            createdEffects[i] = this.effects[i].constructEffect(world, x, y, z, random);
        }
        int[] newDelays = new int[this.delays.length];
        for (int i = 0; i < this.delays.length; ++i) {
            newDelays[i] = this.delays[i];
        }
        return new PBEffectMulti(createdEffects, newDelays);
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        float min = 999.0f;
        for (PBEffectCreator effect : this.effects) {
            min = Math.min(effect.chanceForMoreEffects(world, x, y, z, random), min);
        }
        return min;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

