/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.effects.spawn_entities.EntitySpawnConfiguration;
import ivorius.pandorasbox.effects.spawn_entities.SpawnItemStacksEffect;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.PandorasBoxItemNamer;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.utils.EitherArrayList;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.utils.RandomizedItemTag;
import ivorius.pandorasbox.weighted.WeightedSelector;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public record PBECSpawnItems(IValue number, IValue ticksPerItem, EitherArrayList<RandomizedItemStack, RandomizedItemTag> items, ZValue spawnsFromEffectCenter, Optional<ValueThrow> valueThrow, Optional<ValueSpawn> valueSpawn) implements PBEffectCreator
{
    public static final MapCodec<PBECSpawnItems> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IValue.CODEC.fieldOf("number").forGetter(PBECSpawnItems::number), (App)IValue.CODEC.fieldOf("ticks_per_item").forGetter(PBECSpawnItems::ticksPerItem), (App)RandomizedItemStack.LIST_CODEC.fieldOf("items").forGetter(PBECSpawnItems::items), (App)ZValue.CODEC.fieldOf("spawns_from_effect_center").forGetter(PBECSpawnItems::spawnsFromEffectCenter), (App)ValueThrow.CODEC.optionalFieldOf("value_throw").forGetter(PBECSpawnItems::valueThrow), (App)ValueSpawn.CODEC.optionalFieldOf("value_spawn").forGetter(PBECSpawnItems::valueSpawn)).apply((Applicative)instance, PBECSpawnItems::new));

    public static ValueThrow defaultThrow() {
        return new ValueThrow(new DLinear(0.05, 0.2), new DLinear(0.2, 1.0));
    }

    public static PBEffect constructEffect(class_5819 random, class_1799[] stacks, int time, ValueThrow valueThrow, ValueSpawn valueSpawn, ZValue spawnsFromEffectCenter) {
        boolean canSpawn = valueSpawn != null;
        boolean canThrow = valueThrow != null;
        EntitySpawnConfiguration.Builder builder = EntitySpawnConfiguration.builder(!spawnsFromEffectCenter.getValue(random));
        if (canThrow && (!canSpawn || random.method_43056())) {
            return new PBEffectSpawnEntities(time, stacks.length, new SpawnItemStacksEffect(stacks, PBECSpawnEntities.setEffectThrow(builder, random, valueThrow).build()));
        }
        if (canSpawn) {
            return new PBEffectSpawnEntities(time, stacks.length, new SpawnItemStacksEffect(stacks, PBECSpawnEntities.setEffectSpawn(builder, random, valueSpawn).build()));
        }
        throw new RuntimeException("Both spawnRange and throwStrength are null!");
    }

    public static class_1799[] getItemStacks(class_5819 random, List<RandomizedItemStack> items, int number, boolean split, boolean mixUp, int enchantLevel, boolean giveNames) {
        class_1799[] stacks = new class_1799[number];
        for (int i = 0; i < number; ++i) {
            RandomizedItemStack wrcc = mixUp ? WeightedSelector.selectItem(random, items) : items.get(i);
            class_1799 stack = wrcc.itemStack().method_7972();
            stack.method_7939(wrcc.min() + random.method_43048(wrcc.max() - wrcc.min() + 1));
            PBECSpawnItems.enchantItemStack(enchantLevel, random, stack);
            if (giveNames) {
                stack.method_7977(PandorasBoxItemNamer.getRandomName(random));
            }
            stacks[i] = split ? stack.method_7971(1) : stack;
        }
        return stacks;
    }

    public static void enchantItemStack(int enchantLevel, class_5819 random, class_1799 stack) {
        if (enchantLevel > 0) {
            List enchantments = class_1890.method_8230((class_5819)random, (class_1799)stack, (int)enchantLevel, (boolean)true);
            if (enchantments.isEmpty()) {
                enchantments = class_1890.method_8230((class_5819)random, (class_1799)new class_1799((class_1935)class_1802.field_8529), (int)enchantLevel, (boolean)true);
            }
            if (!enchantments.isEmpty()) {
                for (class_1889 enchantment : enchantments) {
                    stack.method_7978(enchantment.field_9093, enchantment.field_9094);
                }
            }
        }
    }

    @Override
    public PBEffect constructEffect(class_1937 world, double x, double y, double z, class_5819 random) {
        int number = this.number.getValue(random);
        int ticksPerItem = this.ticksPerItem.getValue(random);
        class_1799[] stacks = PBECSpawnItems.getItemStacks(random, PandorasBoxHelper.assembleRandomisedStacks((class_2378<class_1792>)class_7923.field_41178, (class_2378<class_2248>)class_7923.field_41175, this.items), number, random.method_43048(3) != 0, true, 0, false);
        return PBECSpawnItems.constructEffect(random, stacks, number * ticksPerItem + 1, this.valueThrow.orElse(null), this.valueSpawn.orElse(null), this.spawnsFromEffectCenter);
    }

    @Override
    public float chanceForMoreEffects(class_1937 world, double x, double y, double z, class_5819 random) {
        return 0.1f;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffectCreator> codec() {
        return CODEC;
    }
}

