/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effectholder.EffectHolder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntityIDListEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.EntityInit;
import ivorius.pandorasbox.init.Init;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.NotNull;

public class PBEffectDuplicateBox
extends PBEffectNormal {
    public static final int MODE_BOX_IN_BOX = 0;
    public static final MapCodec<PBEffectDuplicateBox> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("spawn_mode").forGetter(PBEffectDuplicateBox::getSpawnMode), (App)EffectHolder.CODEC.optionalFieldOf("included_effect_holders", (Object)class_6885.method_40246((class_6880[])new class_6880[0])).forGetter(PBEffectDuplicateBox::getIncludedEffectHolders)).apply((Applicative)instance, PBEffectDuplicateBox::new));
    public class_6885<EffectHolder> includedEffectHolders;
    public int spawnMode;

    public static int timeNeededForSpawnMode(int mode) {
        if (mode == 0) {
            return 60;
        }
        return 0;
    }

    public PBEffectDuplicateBox(int spawnMode) {
        super(PBEffectDuplicateBox.timeNeededForSpawnMode(spawnMode));
        this.spawnMode = spawnMode;
        this.includedEffectHolders = class_6885.method_40246((class_6880[])new class_6880[0]);
    }

    public PBEffectDuplicateBox(int spawnMode, class_6885<EffectHolder> includedEffectHolders) {
        super(PBEffectDuplicateBox.timeNeededForSpawnMode(spawnMode));
        this.spawnMode = spawnMode;
        this.includedEffectHolders = includedEffectHolders;
    }

    public int getSpawnMode() {
        return this.spawnMode;
    }

    public class_6885<EffectHolder> getIncludedEffectHolders() {
        return this.includedEffectHolders;
    }

    @Override
    public void setUpEffect(class_1937 level, PandorasBoxEntity box, class_243 effectCenter, class_5819 random) {
        if (!level.method_8608()) {
            PBEffect effect = PBECRegistry.createRandomEffect(level, random, box.method_23317(), box.method_23318(), box.method_23321(), true, Optional.of(this.includedEffectHolders), Init.EFFECT_HOLDER_REGISTRY_KEY);
            PandorasBoxEntity newBox = new PandorasBoxEntity(EntityInit.BOX, level, true, true, box.hasFoil);
            newBox.setBoxEffect(effect);
            newBox.setBoxWaitingTime(40);
            newBox.setRenderItem(box.getRenderItem());
            SpawnEntityIDListEffect.moveTo(newBox, box.method_19538(), box.method_36454(), box.method_36455());
            if (this.spawnMode == 0) {
                newBox.beginFloating();
                newBox.beginScalingIn();
                level.method_8649((class_1297)newBox);
            }
        }
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

