/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.effects.generate.GenerateEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class PBEffectGenerate
extends PBEffectRangeBased {
    public static final MapCodec<PBEffectGenerate> CODEC = RecordCodecBuilder.mapCodec(instance -> PBEffectRangeBased.baseFields(instance).and((App)GenerateEffect.CODEC.fieldOf("effect").forGetter(PBEffectGenerate::getGenerateEffect)).apply((Applicative)instance, PBEffectGenerate::new));
    public final GenerateEffect generateEffect;

    public PBEffectGenerate(int time, double range, int passes, int unifiedSeed, GenerateEffect generateEffect) {
        super(time, range, passes, unifiedSeed);
        this.generateEffect = generateEffect;
    }

    public GenerateEffect getGenerateEffect() {
        return this.generateEffect;
    }

    public void changeBiome(class_5321<class_1959> biomeResourceKey, int baseX, int baseY, int baseZ, class_3218 serverLevel, List<class_2791> chunks) {
        double range = this.range + (double)(this.passes - 1) * 5.0;
        for (class_2791 chunkAccess : chunks) {
            class_2378 biomeRegistry = serverLevel.method_30349().method_30530(class_7924.field_41236);
            class_6880.class_6883 biome = biomeRegistry.method_40290(biomeResourceKey);
            chunkAccess.method_38257((arg_0, arg_1, arg_2, arg_3) -> PBEffectGenerate.lambda$changeBiome$1(chunkAccess, baseX, baseY, baseZ, range, (class_6880)biome, arg_0, arg_1, arg_2, arg_3), serverLevel.method_14178().method_41248().method_42371());
            chunkAccess.method_12008(true);
        }
        serverLevel.method_14178().field_17254.method_49421(chunks);
    }

    @Override
    public void generateInRange(class_1937 level, PandorasBoxEntity entity, class_5819 random, class_243 effectCenter, double prevRange, double newRange, int pass) {
        int requiredRange = class_3532.method_15384((double)newRange);
        int baseX = class_3532.method_15357((double)effectCenter.field_1352);
        int baseY = class_3532.method_15357((double)effectCenter.field_1351);
        int baseZ = class_3532.method_15357((double)effectCenter.field_1350);
        double newRatio = this.getRatioDone(entity.getTicksForEffect(this) + 1);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int y = -requiredRange; y <= requiredRange; ++y) {
                for (int z = -requiredRange; z <= requiredRange; ++z) {
                    double dist = class_3532.method_15355((float)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateEffect.generateOnBlock(level, entity, effectCenter, random, pass, new class_2338(baseX + x, baseY + y, baseZ + z), dist, newRatio, this.unifiedSeed);
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    @Override
    public void setUpEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random) {
        int baseX = class_3532.method_15357((double)effectCenter.field_1352);
        int baseY = class_3532.method_15357((double)effectCenter.field_1351);
        int baseZ = class_3532.method_15357((double)effectCenter.field_1350);
        class_5321<class_1959> biomeResourceKey = this.generateEffect.biome();
        if (biomeResourceKey != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ArrayList<class_2791> chunks = new ArrayList<class_2791>();
            int sectionRange = class_4076.method_42615((double)(this.range + (double)(this.passes - 1) * 5.0));
            int baseSectionX = class_4076.method_18675((int)baseX);
            int baseSectionZ = class_4076.method_18675((int)baseZ);
            for (int cz = -sectionRange; cz <= sectionRange; ++cz) {
                for (int cx = -sectionRange; cx <= sectionRange; ++cx) {
                    class_2791 chunk = serverLevel.method_8402(cx + baseSectionX, cz + baseSectionZ, class_2806.field_12803, false);
                    if (chunk == null) continue;
                    chunks.add(chunk);
                }
            }
            this.changeBiome(biomeResourceKey, baseX, baseY, baseZ, serverLevel, chunks);
        }
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }

    private static /* synthetic */ class_6880 lambda$changeBiome$1(class_2791 chunkAccess, int baseX, int baseY, int baseZ, double range, class_6880 biome, int i, int j, int k, class_6544.class_6552 sampler) {
        int l = class_5742.method_33101((int)i);
        int m = class_5742.method_33101((int)j);
        int n = class_5742.method_33101((int)k);
        class_6880 holder2 = chunkAccess.method_16359(i, j, k);
        int x = l - baseX;
        int y = m - baseY;
        int z = n - baseZ;
        double dist = class_3532.method_15355((float)(x * x + y * y + z * z));
        if (dist <= range) {
            return biome;
        }
        return holder2;
    }
}

