/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.structure.Structure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public abstract class PBEffectGenerateByStructure<T extends Structure>
extends PBEffectNormal {
    public T[] structures;

    public PBEffectGenerateByStructure(int maxTicksAlive) {
        super(maxTicksAlive);
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        if (!level.method_8608()) {
            for (T structure : this.structures) {
                float newStructureRatio = this.getStructureRatio(newRatio, (Structure)structure);
                float prevStructureRatio = this.getStructureRatio(prevRatio, (Structure)structure);
                int baseX = class_3532.method_15357((double)effectCenter.field_1352);
                int baseY = class_3532.method_15357((double)effectCenter.field_1351);
                int baseZ = class_3532.method_15357((double)effectCenter.field_1350);
                if (!(newStructureRatio > prevStructureRatio)) continue;
                this.generateStructure(level, entity, random, structure, new class_2338(baseX, baseY, baseZ), newStructureRatio, prevStructureRatio);
            }
        }
    }

    private float getStructureRatio(float ratio, Structure structure) {
        return class_3532.method_15363((float)((ratio - structure.structureStart) / structure.structureLength), (float)0.0f, (float)1.0f);
    }

    public T[] getStructures() {
        return this.structures;
    }

    public abstract void generateStructure(class_1937 var1, PandorasBoxEntity var2, class_5819 var3, T var4, class_2338 var5, float var6, float var7);

    public abstract T createStructure();

    public static void applyRandomProperties(Structure structure, double range, class_5819 random) {
        structure.structureLength = random.method_43057() * 0.8f + 0.1f;
        structure.structureStart = random.method_43057() * (1.0f - structure.structureLength);
        structure.pos = new class_2382(class_3532.method_15357((double)((random.method_43058() - random.method_43058()) * range)), class_3532.method_15357((double)((random.method_43058() - random.method_43058()) * range)), class_3532.method_15357((double)((random.method_43058() - random.method_43058()) * range)));
        structure.unifiedSeed = PandorasBoxHelper.getRandomUnifiedSeed(random);
    }
}

