/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Arrays;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class PBEffectMulti
extends PBEffect {
    public static final class_2960 MULTI = new class_2960("pandorasbox", "render_multi");
    public static final MapCodec<PBEffectMulti> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(PBEffect.CODEC, () -> new PBEffect[0]).fieldOf("effects").forGetter(PBEffectMulti::getEffects), (App)PBNBTHelper.arrayCodec(Codec.INT, () -> new Integer[0]).fieldOf("delays").forGetter(pbEffectMulti -> (Integer[])Arrays.stream(pbEffectMulti.getDelays()).boxed().toArray(Integer[]::new))).apply((Applicative)instance, PBEffectMulti::new));
    public final PBEffect[] effects;
    public final int[] delays;

    public PBEffectMulti(PBEffect[] effects, int[] delays) {
        this.effects = effects;
        this.delays = delays;
    }

    public PBEffectMulti(PBEffect[] effects, Integer[] delays) {
        this(effects, Arrays.stream(delays).mapToInt(Integer::intValue).toArray());
    }

    public PBEffect[] getEffects() {
        return this.effects;
    }

    public int[] getDelays() {
        return this.delays;
    }

    @Override
    public void doTick(PandorasBoxEntity entity, class_243 effectCenter, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            this.effects[i].doTick(entity, effectCenter, effectTicks);
        }
    }

    @Override
    public boolean isDone(int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            if (this.effects[i].isDone(effectTicks)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        for (PBEffect effect : this.effects) {
            if (effect.canGenerateMoreEffectsAfterwards(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTicksExistedForEffect(PBEffect identityEffect, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            if (this.effects[i] != identityEffect) continue;
            return ticksAlive - this.delays[i];
        }
        return -1;
    }

    @Override
    public int getMaxTicksAlive() {
        int highestLength = 0;
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = this.effects[i].getMaxTicksAlive() + this.delays[i];
            if (effectTicks < highestLength) continue;
            highestLength = effectTicks;
        }
        return highestLength;
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }

    @Override
    public class_2960 rendererResourceLocationForEffect() {
        return MULTI;
    }
}

