/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public abstract class PBEffectRangeBased
extends PBEffectNormal {
    public final int unifiedSeed;
    public final double range;
    public final int passes;

    public PBEffectRangeBased(int maxTicksAlive, double range, int passes, int unifiedSeed) {
        super(maxTicksAlive);
        this.range = range;
        this.passes = passes;
        this.unifiedSeed = unifiedSeed;
    }

    public int getUnifiedSeed() {
        return this.unifiedSeed;
    }

    public double getRange() {
        return this.range;
    }

    public int getPasses() {
        return this.passes;
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        for (int i = 0; i < this.passes; ++i) {
            double prevRange = this.getRange(prevRatio, i);
            double newRange = this.getRange(newRatio, i);
            this.generateInRange(level, entity, random, effectCenter, prevRange, newRange, i);
        }
    }

    protected double getRange(double ratio, int pass) {
        ratio = IvMathHelper.mixEaseInOut(0.0, 1.0, Math.sqrt(ratio));
        double fullRange = this.range + (double)(this.passes - 1) * 5.0;
        double tempRange = ratio * fullRange - (double)pass * 5.0;
        return class_3532.method_15350((double)tempRange, (double)0.0, (double)this.range);
    }

    public abstract void generateInRange(class_1937 var1, PandorasBoxEntity var2, class_5819 var3, class_243 var4, double var5, double var7, int var9);

    public static <T extends PBEffectRangeBased> Products.P4<RecordCodecBuilder.Mu<T>, Integer, Double, Integer, Integer> baseFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group(PBEffectRangeBased.base(), (App)Codec.DOUBLE.fieldOf("range").forGetter(PBEffectRangeBased::getRange), (App)Codec.INT.fieldOf("passes").forGetter(PBEffectRangeBased::getPasses), (App)Codec.INT.fieldOf("unified_seed").forGetter(PBEffectRangeBased::getUnifiedSeed));
    }
}

