/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.spawn_entities.SpawnEntitiesEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PBEffectSpawnEntities
extends PBEffectNormal {
    public static final MapCodec<PBEffectSpawnEntities> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PBEffectSpawnEntities.base(), (App)Codec.INT.fieldOf("number").forGetter(PBEffectSpawnEntities::getNumber), (App)SpawnEntitiesEffect.CODEC.fieldOf("effect").forGetter(PBEffectSpawnEntities::getEffect)).apply((Applicative)instance, PBEffectSpawnEntities::new));
    public final int number;
    public final SpawnEntitiesEffect effect;

    public PBEffectSpawnEntities(int time, int number, SpawnEntitiesEffect effect) {
        super(time);
        this.number = number;
        this.effect = effect;
    }

    @Override
    public void doEffect(class_1937 level, PandorasBoxEntity box, class_243 effectCenter, class_5819 random, float prevRatio, float newRatio) {
        if (!level.method_8608()) {
            int prev = this.getSpawnNumber(prevRatio);
            int toSpawn = this.getSpawnNumber(newRatio) - prev;
            for (int i = 0; i < toSpawn; ++i) {
                double eZ;
                double eY;
                double eX;
                class_243 baseVec = this.effect.spawnsFromBox() ? box.method_19538() : effectCenter;
                if (this.effect.spawnDirect()) {
                    eX = baseVec.field_1352;
                    eY = baseVec.field_1351;
                    eZ = baseVec.field_1350;
                } else {
                    eX = baseVec.field_1352 + (random.method_43058() - random.method_43058()) * this.effect.range();
                    eY = baseVec.field_1351 + (random.method_43058() - random.method_43058()) * 3.0 + this.effect.shiftY();
                    eZ = baseVec.field_1350 + (random.method_43058() - random.method_43058()) * this.effect.range();
                }
                class_1297 newEntity = this.effect.spawnEntity(level, box, random, prev + i, eX, eY, eZ);
                if (newEntity == null || !this.effect.spawnDirect() || newEntity instanceof class_1309) continue;
                float dirSide = random.method_43057() * 2.0f * 3.1415925f;
                double throwStrengthSide = this.effect.throwStrengthSideMin() + random.method_43058() * (this.effect.throwStrengthSideMax() - this.effect.throwStrengthSideMin());
                newEntity.method_5762((double)class_3532.method_15374((float)dirSide) * throwStrengthSide, this.effect.throwStrengthYMin() + random.method_43058() * (this.effect.throwStrengthYMax() - this.effect.throwStrengthYMin()), (double)class_3532.method_15362((float)dirSide) * throwStrengthSide);
                newEntity.field_6037 = true;
            }
        }
    }

    public SpawnEntitiesEffect getEffect() {
        return this.effect;
    }

    public int getNumber() {
        return this.number;
    }

    private int getSpawnNumber(float ratio) {
        return class_3532.method_15375((float)(ratio * (float)this.number));
    }

    @Override
    @NotNull
    public MapCodec<? extends PBEffect> codec() {
        return CODEC;
    }
}

