/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectDuplicateBox;
import ivorius.pandorasbox.init.DataSerializerInit;
import ivorius.pandorasbox.init.Init;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class PandorasBoxEntity
extends class_1297
implements class_6025 {
    public static final Codec<Optional<class_1799>> RENDER_ITEM_CODEC = class_1799.field_24671.optionalFieldOf("renderItem").codec();
    public static final Codec<Optional<class_243>> EFFECT_CENTER_CODEC = class_243.field_38277.optionalFieldOf("effectCenter").codec();
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final class_2940<Integer> BOX_DEATH_TICKS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BOX_WAITING_TIME = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EFFECT_TICKS_EXISTED = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13327);
    protected boolean canGenerateMoreEffectsAfterwards;
    protected boolean floatUp;
    public boolean hasFoil;
    private static final class_2940<Float> FLOAT_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_PROGRESS = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<PBEffect> DATA_EFFECT_ID = class_2945.method_12791(PandorasBoxEntity.class, DataSerializerInit.PBEFFECTSERIALIZER);
    private static final class_2940<Optional<UUID>> DATA_OWNER_UUID = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_1799> DATA_RENDER_ITEM = class_2945.method_12791(PandorasBoxEntity.class, (class_2941)class_2943.field_13322);
    protected class_243 effectCenter = new class_243(0.0, 0.0, 0.0);

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> p_i50172_1_, class_1937 p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
        this.canGenerateMoreEffectsAfterwards = true;
        this.floatUp = false;
        this.hasFoil = false;
    }

    public PandorasBoxEntity(class_1299<? extends PandorasBoxEntity> entityType, class_1937 level, boolean canGenerateMoreEffectsAfterwards, boolean floatUp, boolean hasFoil) {
        super(entityType, level);
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
        this.floatUp = floatUp;
        this.hasFoil = hasFoil;
    }

    public boolean method_30949(@NotNull class_1297 p_241849_1_) {
        return false;
    }

    public class_5819 getRandom() {
        return this.field_5974;
    }

    public class_243 getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(class_243 effectCenter) {
        this.effectCenter = effectCenter;
    }

    public int getBoxWaitingTime() {
        return (Integer)this.field_6011.method_12789(BOX_WAITING_TIME);
    }

    public void setBoxWaitingTime(int amount) {
        this.field_6011.method_12778(BOX_WAITING_TIME, (Object)amount);
    }

    public int getEffectTicksExisted() {
        return (Integer)this.field_6011.method_12789(EFFECT_TICKS_EXISTED);
    }

    public void setEffectTicksExisted(int amount) {
        this.field_6011.method_12778(EFFECT_TICKS_EXISTED, (Object)amount);
    }

    public float getCurrentScale() {
        return ((Float)this.field_6011.method_12789(SCALE_PROGRESS)).floatValue();
    }

    public void setScale(float amount) {
        this.field_6011.method_12778(SCALE_PROGRESS, (Object)Float.valueOf(amount));
    }

    public float getFloatProgress() {
        return ((Float)this.field_6011.method_12789(FLOAT_PROGRESS)).floatValue();
    }

    public void setFloatProgress(float amount) {
        this.field_6011.method_12778(FLOAT_PROGRESS, (Object)Float.valueOf(amount));
    }

    protected void method_5693() {
        this.field_6011.method_12784(BOX_DEATH_TICKS, (Object)-1);
        this.field_6011.method_12784(BOX_WAITING_TIME, (Object)-1);
        this.field_6011.method_12784(EFFECT_TICKS_EXISTED, (Object)-1);
        this.field_6011.method_12784(FLOAT_PROGRESS, (Object)Float.valueOf(-1.0f));
        this.field_6011.method_12784(SCALE_PROGRESS, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(DATA_EFFECT_ID, (Object)new PBEffectDuplicateBox(0));
        this.field_6011.method_12784(DATA_OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(DATA_RENDER_ITEM, (Object)class_1799.field_8037);
    }

    public int getTicksForEffect(PBEffect identityEffect) {
        if (this.getBoxWaitingTime() == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            return effect.getTicksExistedForEffect(identityEffect, this.getEffectTicksExisted());
        }
        return -2;
    }

    public void method_5773() {
        float scaleInProgress;
        class_1937 level = this.method_37908();
        super.method_5773();
        int timeBoxWaiting = this.getBoxWaitingTime();
        int effectTicksExisted = this.getEffectTicksExisted();
        if (timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (!level.method_8608()) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else if (effect.isDone(effectTicksExisted)) {
                if (!level.method_8608()) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.field_5974.method_43057() < (Double)PandorasBox.CONFIG.boxLongevity.get()) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (effectTicksExisted == 0) {
                    this.setEffectCenter(this.method_19538());
                }
                effect.doTick(this, this.effectCenter, effectTicksExisted);
            }
        }
        if (timeBoxWaiting == 0) {
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            this.method_18799(this.method_18798().method_1021(0.95));
        }
        float floatAwayProgress = this.getFloatProgress();
        if (floatAwayProgress >= 0.0f && floatAwayProgress < 1.0f) {
            float speed = class_3532.method_27285((float)(floatAwayProgress - 0.7f));
            if (this.floatUp) {
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            } else {
                this.method_5724(0.4f, new class_243(-0.0, (double)(speed * 0.02f), (double)-0.02f));
                this.method_18799(this.method_18798().method_1031(0.0, (double)(speed * 0.015f), 0.0));
            }
            this.setFloatProgress(floatAwayProgress += 0.025f);
            if (floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if ((scaleInProgress = this.getCurrentScale()) < 1.0f) {
            scaleInProgress += 0.02f;
        }
        if (scaleInProgress > 1.0f) {
            scaleInProgress = 1.0f;
        }
        this.setScale(scaleInProgress);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0 && !this.method_5767() && level.method_8608()) {
                double zP;
                double yDir;
                double xP;
                int e;
                double yCenter = this.method_23318() + (double)this.method_17682() * 0.5;
                for (e = 0; e < 2; ++e) {
                    xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                    yDir = this.field_5974.method_43058() * 0.1;
                    zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2;
                    level.method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, yCenter, this.method_23321() + zP, 0.0, yDir, 0.0);
                }
                for (e = 0; e < 3; ++e) {
                    double xDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                    yDir = this.field_5974.method_43058() * 4.0 + 2.0;
                    double zDir = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 3.0;
                    double xP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                    double zP2 = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
                    level.method_8406((class_2394)class_2398.field_11215, this.method_23317() + xP2 + xDir, yCenter + yDir, this.method_23321() + zP2 + zDir, -xDir, -yDir, -zDir);
                }
                for (e = 0; e < 4; ++e) {
                    xP = this.field_5974.method_43058() * 16.0 - 8.0;
                    double yP = this.field_5974.method_43058() * 5.0 - 2.0;
                    zP = this.field_5974.method_43058() * 16.0 - 8.0;
                    double xDir = this.field_5974.method_43058() * 2.0 - 1.0;
                    double yDir2 = this.field_5974.method_43058() * 2.0 - 1.0;
                    double zDir = this.field_5974.method_43058() * 2.0 - 1.0;
                    level.method_8406((class_2394)class_2398.field_11214, this.method_23317() + xP, yCenter + yP, this.method_23321() + zP, xDir, yDir2, zDir);
                }
            }
            this.setEffectTicksExisted(++effectTicksExisted);
        } else {
            this.setBoxWaitingTime(--timeBoxWaiting);
        }
        int deathTicks = this.getDeathTicks();
        if (deathTicks >= 0) {
            if (!level.method_8608()) {
                if (deathTicks >= 30) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            } else {
                for (int e = 0; e < Math.min(deathTicks, 60); ++e) {
                    double xP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double yP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    double zP = (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.5;
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + xP, this.method_23318() + yP, this.method_23321() + zP, 0.0, 0.0, 0.0);
                }
            }
            this.setDeathTicks(deathTicks + 1);
        }
    }

    public void startNewEffect() {
        this.setEffectTicksExisted(0);
        this.setBoxWaitingTime(this.field_5974.method_43048(40));
        this.field_6011.method_12778(DATA_EFFECT_ID, (Object)this.ensureNotNull(PBECRegistry.createRandomEffect(this.method_37908(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true, Optional.empty(), Init.EFFECT_HOLDER_REGISTRY_KEY)));
    }

    public void setRenderItem(class_1799 renderItem) {
        this.field_6011.method_12778(DATA_RENDER_ITEM, (Object)renderItem);
    }

    public class_1799 getRenderItem() {
        return (class_1799)this.field_6011.method_12789(DATA_RENDER_ITEM);
    }

    public void setOwnerUUID(UUID uuid) {
        if (uuid == null) {
            return;
        }
        this.field_6011.method_12778(DATA_OWNER_UUID, Optional.of(uuid));
    }

    public UUID method_6139() {
        if (((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).isEmpty()) {
            return null;
        }
        return (UUID)((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).get();
    }

    public void setBoxOwner(class_1657 player) {
        if (player == null) {
            return;
        }
        this.field_6011.method_12778(DATA_OWNER_UUID, Optional.of(player.method_5667()));
    }

    public class_1657 getBoxOwner() {
        if (((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).isEmpty()) {
            return null;
        }
        return this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(DATA_OWNER_UUID)).get());
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloating() {
        this.setFloatProgress(0.0f);
    }

    public void stopFloating() {
        this.setFloatProgress(-1.0f);
        this.setEffectTicksExisted(0);
    }

    public void beginScalingIn() {
        this.setScale(0.0f);
    }

    public PBEffect getBoxEffect() {
        return (PBEffect)this.field_6011.method_12789(DATA_EFFECT_ID);
    }

    public void setBoxEffect(PBEffect effect) {
        this.field_6011.method_49743(DATA_EFFECT_ID, (Object)this.ensureNotNull(effect), true);
    }

    public PBEffect ensureNotNull(PBEffect input) {
        while (input == null) {
            input = PBECRegistry.createRandomEffect(this.method_37908(), this.field_5974, this.effectCenter.field_1352, this.effectCenter.field_1351, this.effectCenter.field_1350, true, Optional.empty(), Init.EFFECT_HOLDER_REGISTRY_KEY);
        }
        return input;
    }

    public int getDeathTicks() {
        return (Integer)this.method_5841().method_12789(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.method_5841().method_12778(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.getFloatProgress() >= 0.0f) {
            return class_3532.method_15363((float)((this.getFloatProgress() + partialTicks * 0.025f - 0.5f) * 2.0f), (float)-0.025f, (float)1.0f);
        }
        return 1.0f;
    }

    public class_2596<class_2602> method_18002() {
        int data = this.hasFoil ? 1 : 0;
        data <<= 1;
        data |= this.canGenerateMoreEffectsAfterwards ? 1 : 0;
        data <<= 1;
        return new class_2604((class_1297)this, data |= this.floatUp ? 1 : 0);
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.hasFoil = (clientboundAddEntityPacket.method_11166() & 4) == 4;
        this.canGenerateMoreEffectsAfterwards = (clientboundAddEntityPacket.method_11166() & 2) == 2;
        this.floatUp = (clientboundAddEntityPacket.method_11166() & 1) == 1;
    }

    public void method_5697(@NotNull class_1297 entityIn) {
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        return false;
    }

    protected void method_5749(class_2487 compoundTag) {
        this.readBoxData(compoundTag);
    }

    protected void method_5652(class_2487 compoundTag) {
        this.writeBoxData(compoundTag);
    }

    public void readBoxData(class_2487 compound) {
        this.setBoxEffect(PandorasBoxEntity.loadEffect(compound.method_10580("boxEffect"), this.method_37908().method_30349()));
        if (compound.method_10545("ownerUUID")) {
            this.setOwnerUUID(compound.method_25926("ownerUUID"));
        }
        this.setEffectTicksExisted(compound.method_10550("effectTicksExisted"));
        this.setBoxWaitingTime(compound.method_10550("timeBoxWaiting"));
        this.canGenerateMoreEffectsAfterwards = compound.method_10577("canGenerateMoreEffectsAfterwards");
        this.setFloatProgress(compound.method_10583("floatAwayProgress"));
        this.floatUp = compound.method_10577("floatUp");
        this.hasFoil = compound.method_10577("hasFoil");
        this.setScale(compound.method_10583("scaleInProgress"));
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_37908().method_30349());
        Optional renderItem = (Optional)RENDER_ITEM_CODEC.parse((DynamicOps)registryOps, (Object)compound).getOrThrow(false, str -> {});
        renderItem.ifPresent(this::setRenderItem);
        AtomicBoolean wasError = new AtomicBoolean(false);
        class_243 effectCenter = ((Optional)EFFECT_CENTER_CODEC.parse((DynamicOps)registryOps, (Object)compound).getOrThrow(false, str -> {})).orElseGet(() -> {
            wasError.set(true);
            return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
        });
        if (wasError.get()) {
            Optional<Double> x = this.readOptionalField("effectCenterX", compound);
            Optional<Double> y = this.readOptionalField("effectCenterY", compound);
            Optional<Double> z = this.readOptionalField("effectCenterZ", compound);
            if (x.isPresent() && y.isPresent() && z.isPresent()) {
                effectCenter = new class_243(x.get().doubleValue(), y.get().doubleValue(), z.get().doubleValue());
            }
        }
        this.setEffectCenter(effectCenter);
    }

    public void writeBoxData(class_2487 compound) {
        compound.method_10566("boxEffect", PandorasBoxEntity.writeEffect(this.getBoxEffect(), this.method_37908().method_30349()));
        UUID uuid = this.method_6139();
        if (uuid != null) {
            compound.method_25927("ownerUUID", uuid);
        }
        compound.method_10569("effectTicksExisted", this.getEffectTicksExisted());
        compound.method_10569("timeBoxWaiting", this.getBoxWaitingTime());
        compound.method_10556("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        compound.method_10548("floatAwayProgress", this.getFloatProgress());
        compound.method_10556("floatUp", this.floatUp);
        compound.method_10556("hasFoil", this.hasFoil);
        compound.method_10548("scaleInProgress", this.getCurrentScale());
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_37908().method_30349());
        if (!this.getRenderItem().method_7960()) {
            class_2520 renderItem = (class_2520)class_1799.field_24671.encodeStart((DynamicOps)registryOps, (Object)this.getRenderItem()).getOrThrow(false, str -> {});
            compound.method_10566("renderItem", renderItem);
        }
        class_2520 effectCenter = (class_2520)class_243.field_38277.encodeStart((DynamicOps)registryOps, (Object)this.effectCenter).getOrThrow(false, str -> {});
        compound.method_10566("effectCenter", effectCenter);
    }

    public Optional<Double> readOptionalField(String name, class_2487 tag) {
        return tag.method_10545(name) ? Optional.of(tag.method_10574(name)) : Optional.empty();
    }

    public static class_2520 writeEffect(PBEffect effect, class_5455 registryAccess) {
        if (effect != null) {
            return (class_2520)PBEffect.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryAccess), (Object)effect).getOrThrow(false, str -> {});
        }
        return new class_2487();
    }

    public static class_2520 writeEffectWithoutRegistries(PBEffect effect, Optional<class_5455> registryAccess) {
        if (registryAccess.isPresent()) {
            return PandorasBoxEntity.writeEffect(effect, registryAccess.get());
        }
        if (effect != null) {
            return (class_2520)PBEffect.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)effect).getOrThrow(false, str -> {});
        }
        return new class_2487();
    }

    public static PBEffect loadEffect(class_2520 tag, class_5455 registryAccess) {
        return (PBEffect)PBEffect.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryAccess), (Object)tag).get().map(Function.identity(), pbEffectError -> {
            PandorasBox.logger.error("Failed to parse box, using fallback. Error: " + pbEffectError.message());
            return new PBEffectDuplicateBox(0);
        });
    }

    public static PBEffect loadEffectWithoutRegistries(class_2520 tag, Optional<class_5455> registryAccess) {
        if (registryAccess.isPresent()) {
            return PandorasBoxEntity.loadEffect(tag, registryAccess.get());
        }
        return (PBEffect)PBEffect.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).get().map(Function.identity(), pbEffectError -> {
            PandorasBox.logger.error("Failed to parse box, using fallback. Error: " + pbEffectError.message());
            return new PBEffectDuplicateBox(0);
        });
    }
}

