/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.random;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record IFlags(int minFlags, Integer[] flags, Double[] chances) implements IValue
{
    public static final MapCodec<IFlags> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_flags").forGetter(IFlags::minFlags), (App)PBNBTHelper.arrayCodec(Codec.INT, () -> new Integer[0]).fieldOf("flags").forGetter(IFlags::flags), (App)PBNBTHelper.arrayCodec(Codec.DOUBLE, () -> new Double[0]).fieldOf("chances").forGetter(IFlags::chances)).apply((Applicative)instance, IFlags::new)), iFlags -> {
        if (iFlags.flags.length != iFlags.chances.length) {
            return DataResult.error(() -> "Misaligned flags and chances!");
        }
        return DataResult.success((Object)iFlags);
    });

    public IFlags(int minFlags, Object ... flagsWithChances) {
        this(minFlags, new Integer[flagsWithChances.length / 2], new Double[flagsWithChances.length / 2]);
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = (Integer)flagsWithChances[i * 2];
            this.chances[i] = (Double)flagsWithChances[i * 2 + 1];
        }
    }

    @Override
    public int getValue(class_5819 random) {
        int value = 0;
        int flagsSet = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!(random.method_43058() < this.chances[i])) continue;
            value |= 1 << this.flags[i];
            ++flagsSet;
        }
        while (flagsSet < this.minFlags) {
            int[] values = new int[this.flags.length - flagsSet];
            double[] weights = new double[values.length];
            int currentIndex = 0;
            for (int i = 0; i < values.length; ++i) {
                while ((flagsSet & 1 << this.flags[currentIndex]) > 0) {
                    ++currentIndex;
                }
                values[i] = this.flags[currentIndex];
                weights[i] = this.chances[currentIndex];
                ++currentIndex;
            }
            value |= 1 << IFlags.getRandomValue(random, values, weights);
            ++flagsSet;
        }
        return value;
    }

    @Override
    @NotNull
    public MapCodec<? extends IValue> codec() {
        return CODEC;
    }

    public static int getRandomValue(class_5819 random, int[] values, double[] weights) {
        double total = 0.0;
        for (double weight : weights) {
            total += weight;
        }
        double selected = random.method_43058() * total;
        for (int i = 0; i < weights.length; ++i) {
            if (!((selected -= weights[i]) < 0.0)) continue;
            return values[i];
        }
        throw new RuntimeException("Weights have invalid values!");
    }
}

