/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.random;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record IWeighted(Integer[] values, Integer[] weights) implements IValue
{
    public static final MapCodec<IWeighted> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)PBNBTHelper.arrayCodec(Codec.INT, () -> new Integer[0]).fieldOf("values").forGetter(IWeighted::values), (App)PBNBTHelper.arrayCodec(Codec.INT, () -> new Integer[0]).fieldOf("weights").forGetter(IWeighted::weights)).apply((Applicative)instance, IWeighted::new)), iWeighted -> {
        if (iWeighted.values.length != iWeighted.weights.length) {
            return DataResult.error(() -> "Weighted value provided without aligned values and weights!");
        }
        return DataResult.success((Object)iWeighted);
    });

    public IWeighted(int ... valuesWithWeights) {
        this(new Integer[valuesWithWeights.length / 2], new Integer[valuesWithWeights.length / 2]);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = valuesWithWeights[i * 2];
            this.weights[i] = valuesWithWeights[i * 2 + 1];
        }
    }

    @Override
    public int getValue(class_5819 random) {
        int total = IWeighted.getTotalWeight(this.weights);
        int selected = random.method_43048(total);
        for (int i = 0; i < this.weights.length; ++i) {
            if ((selected -= this.weights[i].intValue()) >= 0) continue;
            return this.values[i];
        }
        throw new RuntimeException("Weights have invalid values!");
    }

    @Override
    @NotNull
    public MapCodec<? extends IValue> codec() {
        return CODEC;
    }

    public static int getTotalWeight(Integer[] weights) {
        int weight = 0;
        Integer[] integerArray = weights;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            weight += i2;
        }
        return weight;
    }
}

