/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.PandorasBoxRenderState;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class PandorasBoxRenderer
extends class_897<PandorasBoxEntity, PandorasBoxRenderState>
implements class_3883<PandorasBoxRenderState, PandorasBoxModel> {
    public PandorasBoxModel model;
    public class_2960 texture = class_2960.method_60655((String)"pandorasbox", (String)"textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.method_32167(PandorasBoxModel.LAYER_LOCATION));
        this.field_4673 = 0.6f;
    }

    @NotNull
    public PandorasBoxRenderState createRenderState() {
        return new PandorasBoxRenderState();
    }

    public void render(PandorasBoxRenderState renderState, class_4587 poseStack, class_4597 multiBufferSource, int packedLightIn) {
        super.method_3936((class_10017)renderState, poseStack, multiBufferSource, packedLightIn);
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.yRot));
        PBEffect effect = renderState.pbEffect;
        float boxScale = renderState.boxScale;
        if (boxScale < 1.0f) {
            poseStack.method_22905(boxScale, boxScale, boxScale);
        }
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        int packedOverlay = class_4608.field_21444;
        this.model.setupAnim(renderState);
        boolean visible = !renderState.field_53333;
        boolean visibleToPlayer = !visible && !renderState.invisibleToPlayer;
        class_1921 renderType = this.getRenderType(visible, visibleToPlayer);
        if (renderType != null) {
            class_4588 consumer = multiBufferSource.getBuffer(renderType);
            this.model.method_62100(poseStack, consumer, packedLightIn, packedOverlay, -1);
            if (!effect.isDone(renderState.effectTicksExisted) && renderState.boxDeathTicks < 0) {
                ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>> layers = new ArrayList<class_3887<PandorasBoxRenderState, PandorasBoxModel>>();
                PBEffectRenderer renderer = PBEffectRenderingRegistry.rendererForEffect(effect);
                if (renderer != null) {
                    renderer.renderBox(this, renderState, effect, renderState.partialTicks, poseStack, multiBufferSource, consumer, packedLightIn);
                    List<class_3887<PandorasBoxRenderState, PandorasBoxModel>> renderLayers = renderer.getLayers(this, renderState, effect, this.model, renderState.partialTicks);
                    if (renderLayers != null) {
                        layers.addAll(renderLayers);
                    }
                }
                for (class_3887 class_38872 : layers) {
                    class_38872.method_4199(poseStack, multiBufferSource, packedLightIn, (class_10017)renderState, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22909();
    }

    @Nullable
    protected class_1921 getRenderType(boolean visible, boolean visibleToPlayer) {
        class_2960 resourceLocation = this.texture;
        if (visibleToPlayer) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (visible) {
            return this.model.method_23500(resourceLocation);
        }
        return null;
    }

    public PandorasBoxModel getModel() {
        return this.model;
    }

    public void extractRenderState(PandorasBoxEntity entity, PandorasBoxRenderState entityRenderState, float partialTicks) {
        super.method_62354((class_1297)entity, (class_10017)entityRenderState, partialTicks);
        entityRenderState.xRot = entity.getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f;
        entityRenderState.yRot = entity.method_36454();
        entityRenderState.boxScale = entity.getCurrentScale();
        entityRenderState.partialTicks = partialTicks;
        entityRenderState.effectTicksExisted = entity.getEffectTicksExisted();
        entityRenderState.entityTickCount = entity.field_6012;
        entityRenderState.boxDeathTicks = entity.getDeathTicks();
        entityRenderState.pbEffect = entity.getBoxEffect();
        entityRenderState.invisibleToPlayer = entity.method_5756((class_1657)class_310.method_1551().field_1724);
    }
}

