/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5819;

public abstract class PBEffectNormal
extends PBEffect {
    public final int maxTicksAlive;

    public PBEffectNormal(int maxTicksAlive) {
        this.maxTicksAlive = maxTicksAlive;
    }

    public int getMaxTicksAlive() {
        return this.maxTicksAlive;
    }

    public float getRatioDone(int ticks) {
        if (ticks == this.maxTicksAlive) {
            return 1.0f;
        }
        return (float)ticks / (float)this.maxTicksAlive;
    }

    public abstract void doEffect(class_1937 var1, PandorasBoxEntity var2, class_243 var3, class_5819 var4, float var5, float var6);

    public void setUpEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random) {
    }

    public void finalizeEffect(class_1937 level, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random) {
    }

    @Override
    public void doTick(PandorasBoxEntity entity, class_243 effectCenter, int ticksAlive) {
        float prevRatio = this.getRatioDone(ticksAlive);
        float newRatio = this.getRatioDone(ticksAlive + 1);
        if (ticksAlive == 0) {
            this.setUpEffect(entity.method_37908(), entity, effectCenter, entity.method_59922());
        }
        if (prevRatio >= 0.0f && newRatio <= 1.0f && newRatio > prevRatio) {
            this.doEffect(entity.method_37908(), entity, effectCenter, entity.method_59922(), prevRatio, newRatio);
        }
        if (ticksAlive == this.maxTicksAlive - 1) {
            this.finalizeEffect(entity.method_37908(), entity, effectCenter, entity.method_59922());
        }
    }

    @Override
    public boolean isDone(int ticksAlive) {
        return ticksAlive >= this.maxTicksAlive;
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        return true;
    }

    @Override
    public int getTicksExistedForEffect(PBEffect identityEffect, int ticksAlive) {
        return identityEffect == this ? ticksAlive : -1;
    }

    protected static <T extends PBEffectNormal> RecordCodecBuilder<T, Integer> base() {
        return Codec.INT.fieldOf("max_ticks_alive").forGetter(PBEffectNormal::getMaxTicksAlive);
    }
}

