/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.generate.two_dimensional;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.generate.two_dimensional.Generate2D;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record GenHeightNoise(int minShift, int maxShift, int minTowerSize, int maxTowerSize, int blockSize) implements Generate2D
{
    public static final MapCodec<GenHeightNoise> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_shift").forGetter(GenHeightNoise::minShift), (App)Codec.INT.fieldOf("max_shift").forGetter(GenHeightNoise::maxShift), (App)Codec.INT.fieldOf("min_tower_size").forGetter(GenHeightNoise::minTowerSize), (App)Codec.INT.fieldOf("max_tower_size").forGetter(GenHeightNoise::maxTowerSize), (App)Codec.INT.fieldOf("block_size").forGetter(GenHeightNoise::blockSize)).apply((Applicative)instance, GenHeightNoise::new));

    @Override
    public void generateOnSurface(class_1937 world, PandorasBoxEntity entity, class_243 effectCenter, class_5819 random, class_2338 pos, double distance, double range, int pass, int unifiedSeed) {
        if (!world.method_8608()) {
            int randomX = pos.method_10263() - pos.method_10263() % this.blockSize;
            int randomZ = pos.method_10260() - pos.method_10260() % this.blockSize;
            Random usedRandom = new Random(new Random(randomX).nextLong() ^ new Random(randomZ).nextLong());
            int shift = this.minShift + usedRandom.nextInt(this.maxShift - this.minShift + 1);
            int towerSize = this.minTowerSize + usedRandom.nextInt(this.maxTowerSize - this.minTowerSize + 1);
            int towerMinY = pos.method_10264() - towerSize / 2;
            int minEffectY = towerMinY + Math.min(0, shift);
            int maxEffectY = towerMinY + towerSize + Math.max(0, shift);
            List entityList = world.method_18467(class_1657.class, new class_238((double)pos.method_10263() - 2.0, (double)(minEffectY - 4), (double)pos.method_10260() - 3.0, (double)pos.method_10263() + 4.0, (double)(maxEffectY + 4), (double)pos.method_10260() + 4.0));
            if (entityList.isEmpty()) {
                int y;
                class_2680[] blockStates = new class_2680[towerSize];
                for (y = 0; y < towerSize; ++y) {
                    blockStates[y] = world.method_8320(pos.method_10086(towerSize / 2 - y));
                }
                for (y = 0; y < towerSize; ++y) {
                    PBEffect.setBlockSafe(world, new class_2338(pos.method_10263(), towerMinY + y, pos.method_10260()), blockStates[y]);
                }
            }
        }
    }

    @Override
    @NotNull
    public MapCodec<? extends Generate2D> codec() {
        return CODEC;
    }
}

