/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects.spawn_entities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record EntitySpawnConfiguration(boolean spawnsFromBox, boolean spawnDirect, double range, double shiftY, double throwStrengthSideMin, double throwStrengthSideMax, double throwStrengthYMin, double throwStrengthYMax) {
    public static final MapCodec<EntitySpawnConfiguration> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("comes_from_box").forGetter(EntitySpawnConfiguration::spawnsFromBox), (App)Codec.BOOL.fieldOf("spawn_direct").forGetter(EntitySpawnConfiguration::spawnDirect), (App)Codec.DOUBLE.fieldOf("range").forGetter(EntitySpawnConfiguration::range), (App)Codec.DOUBLE.fieldOf("shift_y").forGetter(EntitySpawnConfiguration::shiftY), (App)Codec.DOUBLE.fieldOf("throw_strength_side_min").forGetter(EntitySpawnConfiguration::throwStrengthSideMin), (App)Codec.DOUBLE.fieldOf("throw_strength_side_max").forGetter(EntitySpawnConfiguration::throwStrengthSideMax), (App)Codec.DOUBLE.fieldOf("throw_strength_y_min").forGetter(EntitySpawnConfiguration::throwStrengthYMin), (App)Codec.DOUBLE.fieldOf("throw_strength_y_max").forGetter(EntitySpawnConfiguration::throwStrengthYMax)).apply((Applicative)instance, EntitySpawnConfiguration::new));

    public static Builder builder(boolean spawnsFromBox) {
        return new Builder(spawnsFromBox);
    }

    public static class Builder {
        boolean spawnsFromBox;
        boolean spawnDirect;
        double range;
        double shiftY;
        double throwStrengthSideMin;
        double throwStrengthSideMax;
        double throwStrengthYMin;
        double throwStrengthYMax;

        public Builder(boolean spawnsFromBox) {
            this.spawnsFromBox = spawnsFromBox;
        }

        public Builder doesNotSpawnDirect(double range, double shiftY) {
            this.spawnDirect = false;
            this.range = range;
            this.shiftY = shiftY;
            return this;
        }

        public Builder doesSpawnDirect(double throwStrengthSideMin, double throwStrengthSideMax, double throwStrengthYMin, double throwStrengthYMax) {
            this.spawnDirect = true;
            this.throwStrengthSideMin = throwStrengthSideMin;
            this.throwStrengthSideMax = throwStrengthSideMax;
            this.throwStrengthYMin = throwStrengthYMin;
            this.throwStrengthYMax = throwStrengthYMax;
            return this;
        }

        public EntitySpawnConfiguration build() {
            return new EntitySpawnConfiguration(this.spawnsFromBox, this.spawnDirect, this.range, this.shiftY, this.throwStrengthSideMin, this.throwStrengthSideMax, this.throwStrengthYMin, this.throwStrengthYMax);
        }
    }
}

