/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.utility;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;

public final class Heads {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    public static void setBase64ToSkullMeta(String base64, SkullMeta meta) {
        PlayerProfile profile = Heads.getProfileBase64(base64);
        meta.setOwnerProfile((org.bukkit.profile.PlayerProfile)profile);
    }

    private static PlayerProfile getProfileBase64(String base64) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = Heads.getUrlFromBase64(base64);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException, IllegalArgumentException {
        URL url;
        String skin = "";
        try {
            JsonObject json;
            String decoded = new String(Base64.getDecoder().decode(base64));
            try {
                json = JsonParser.parseString((String)(decoded + "}")).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                json = JsonParser.parseString((String)decoded).getAsJsonObject();
            }
            if (!json.has("textures")) {
                throw new IllegalArgumentException("Base64 Missing Textures: " + String.valueOf(json));
            }
            JsonObject textures = json.get("textures").getAsJsonObject();
            if (!textures.has("SKIN")) {
                throw new IllegalArgumentException("Textures missing SKIN field: " + String.valueOf(textures));
            }
            skin = textures.get("SKIN").getAsJsonObject().get("url").getAsString();
            url = new URL(skin);
        }
        catch (IllegalArgumentException t) {
            throw new IllegalArgumentException("Invalid base64 string: " + base64);
        }
        catch (JsonSyntaxException t) {
            throw new IllegalArgumentException("Invalid base64 encoded json: " + base64);
        }
        catch (MalformedURLException t) {
            throw new MalformedURLException("Invalid URL: " + skin);
        }
        return url;
    }

    @Generated
    private Heads() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

