/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge.connector.impl.holographic;

import java.util.function.Consumer;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.HologramLines;
import me.filoghost.holographicdisplays.api.hologram.VisibilitySettings;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLine;
import me.filoghost.holographicdisplays.api.hologram.line.ItemHologramLine;
import me.filoghost.holographicdisplays.api.hologram.line.TextHologramLine;
import not.savage.shade.hologrambridge.connector.Connector;
import not.savage.shade.hologrambridge.hologram.Hologram;
import not.savage.shade.hologrambridge.hologram.VisibilityManager;
import not.savage.shade.hologrambridge.hologram.impl.OptimalHologram;
import not.savage.shade.hologrambridge.lines.Line;
import not.savage.shade.hologrambridge.lines.types.ItemLine;
import not.savage.shade.hologrambridge.lines.types.TextLine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Holographic3
implements Connector {
    private final HolographicDisplaysAPI holographicAPI;

    public Holographic3(JavaPlugin javaPlugin) {
        this.holographicAPI = HolographicDisplaysAPI.get((Plugin)javaPlugin);
    }

    @Override
    public Hologram createHologram(Location location) {
        return new OptimalHologram(this, this.holographicAPI.createHologram(location), location);
    }

    @Override
    public void setLine(Hologram hologram, int lineIndex, Line line) {
        this.modifyHologram(hologram, holo -> {
            HologramLines hologramLines = holo.getLines();
            hologramLines.remove(lineIndex);
            if (line instanceof ItemLine) {
                hologramLines.insertItem(lineIndex, ((ItemLine)line).getItemStack());
                return;
            }
            if (line instanceof TextLine) {
                hologramLines.insertText(lineIndex, ((TextLine)line).getText());
            }
        });
    }

    @Override
    public void updateLine(Hologram hologram, int lineIndex, Line line) {
        this.modifyHologram(hologram, holo -> {
            HologramLines hologramLines = holo.getLines();
            HologramLine hologramLine = hologramLines.get(lineIndex);
            if (line instanceof ItemLine && hologramLine instanceof ItemHologramLine) {
                ItemStack itemStack = ((ItemLine)line).getItemStack();
                ((ItemHologramLine)hologramLine).setItemStack(itemStack);
                return;
            }
            if (line instanceof TextLine && hologramLine instanceof TextHologramLine) {
                String text = ((TextLine)line).getText();
                ((TextHologramLine)hologramLine).setText(text);
            }
        });
    }

    @Override
    public void appendLine(Hologram hologram, Line line) {
        this.modifyHologram(hologram, holo -> {
            HologramLines hologramLines = holo.getLines();
            if (line instanceof ItemLine) {
                hologramLines.appendItem(((ItemLine)line).getItemStack());
                return;
            }
            if (line instanceof TextLine) {
                hologramLines.appendText(((TextLine)line).getText());
            }
        });
    }

    @Override
    public void clearLines(Hologram hologram) {
        this.modifyHologram(hologram, holo -> {
            HologramLines lines = holo.getLines();
            lines.clear();
        });
    }

    @Override
    public void teleport(Hologram hologram, Location location) {
        this.modifyHologram(hologram, holo -> holo.setPosition(location));
    }

    @Override
    public void delete(Hologram hologram) {
        this.modifyHologram(hologram, me.filoghost.holographicdisplays.api.hologram.Hologram::delete);
    }

    @Override
    public void setVisibleByDefault(VisibilityManager visibilityManager, boolean visibleByDefault) {
        this.modifyHologram(visibilityManager.getHologram(), hologram -> {
            VisibilitySettings visibilitySettings = hologram.getVisibilitySettings();
            visibilitySettings.setGlobalVisibility(visibleByDefault ? VisibilitySettings.Visibility.VISIBLE : VisibilitySettings.Visibility.HIDDEN);
        });
    }

    @Override
    public void showTo(VisibilityManager visibilityManager, Player player) {
        this.modifyHologram(visibilityManager.getHologram(), hologram -> {
            VisibilitySettings visibilitySettings = hologram.getVisibilitySettings();
            visibilitySettings.setIndividualVisibility(player, VisibilitySettings.Visibility.VISIBLE);
        });
    }

    @Override
    public void hideTo(VisibilityManager visibilityManager, Player player) {
        this.modifyHologram(visibilityManager.getHologram(), hologram -> {
            VisibilitySettings visibilitySettings = hologram.getVisibilitySettings();
            visibilitySettings.setIndividualVisibility(player, VisibilitySettings.Visibility.HIDDEN);
        });
    }

    @Override
    public double getHeight(Hologram hologram) {
        throw new UnsupportedOperationException("HolographicDisplays does not support getting the height!");
    }

    private void modifyHologram(Hologram hologram, Consumer<me.filoghost.holographicdisplays.api.hologram.Hologram> consumer) {
        Object hologramObject = hologram.getHologramAsObject();
        if (!(hologramObject instanceof me.filoghost.holographicdisplays.api.hologram.Hologram)) {
            return;
        }
        consumer.accept((me.filoghost.holographicdisplays.api.hologram.Hologram)hologramObject);
    }
}

