/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.AirHeadsPlugin;
import not.savage.airheads.config.AirHead;
import not.savage.airheads.tasks.FloatAnimationTask;
import not.savage.airheads.utility.Heads;
import not.savage.shade.hologrambridge.HologramAPI;
import not.savage.shade.hologrambridge.hologram.Hologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AirHeadEntity {
    private final float DEFAULT_ARMOR_STAND_HEIGHT = 1.975f;
    private final AirHeadsPlugin plugin;
    private final AirHead config;
    private final int entityId;
    private final String name;
    private final UUID uuid;
    private Location currentLocation;
    private final com.github.retrooper.packetevents.protocol.item.ItemStack headItem;
    private final int floatTask;
    private final Hologram hologram;
    private final long activeAfter;

    public AirHeadEntity(AirHeadsPlugin plugin, String name, AirHead config, long delayedTicks) {
        this.plugin = plugin;
        this.config = config;
        this.currentLocation = config.getLocation().clone().add(0.5, -this.trueHeight(), 0.5);
        this.activeAfter = System.currentTimeMillis() + delayedTicks * 50L;
        this.entityId = SpigotReflectionUtil.generateEntityId();
        this.name = name;
        this.uuid = UUID.randomUUID();
        this.floatTask = new FloatAnimationTask(this.currentLocation, this, this.activeAfter).runTaskTimerAsynchronously((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), 0L, 1L).getTaskId();
        if (!config.getHologramText().isEmpty()) {
            this.hologram = HologramAPI.createHologram(this.currentLocation.clone().add(0.0, this.getHologramOffset(), 0.0));
            for (String line : config.getHologramText()) {
                this.hologram.appendTextLine(MiniMessage.miniMessage().deserialize((Object)line));
            }
            this.hologram.getVisibilityManager().setVisibleByDefault(false);
        } else {
            this.hologram = null;
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        Heads.setBase64ToSkullMeta(config.getHeadTexture(), meta);
        head.setItemMeta((ItemMeta)meta);
        this.headItem = SpigotConversionUtil.fromBukkitItemStack((ItemStack)head);
    }

    public void spawnForPlayer(Player player) {
        CompletableFuture.runAsync(() -> {
            WrapperPlayServerSpawnEntity entitySpawnPacket = new WrapperPlayServerSpawnEntity(this.entityId, this.uuid, SpigotConversionUtil.fromBukkitEntityType((EntityType)EntityType.ARMOR_STAND), SpigotConversionUtil.fromBukkitLocation((Location)this.currentLocation), 0.0f, 0, null);
            WrapperPlayServerEntityEquipment entityEquipPacket = new WrapperPlayServerEntityEquipment(this.entityId, List.of(new Equipment(EquipmentSlot.HELMET, this.headItem)));
            WrapperPlayServerEntityMetadata entityMetaPacket = new WrapperPlayServerEntityMetadata(this.entityId, List.of(new EntityData(0, EntityDataTypes.BYTE, (Object)32)));
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)entitySpawnPacket);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)entityEquipPacket);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)entityMetaPacket);
            if (this.config.getScale() != 1.0) {
                WrapperPlayServerUpdateAttributes entityAttributes = this.createAttributePacket();
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)entityAttributes);
            }
        }).thenAcceptAsync(v -> {});
        this.hologram.getVisibilityManager().showTo(player);
    }

    @NotNull
    private WrapperPlayServerUpdateAttributes createAttributePacket() {
        WrapperPlayServerUpdateAttributes.Property scale = new WrapperPlayServerUpdateAttributes.Property(Attributes.SCALE, this.config.getScale(), new ArrayList());
        WrapperPlayServerUpdateAttributes.Property interactionRange = new WrapperPlayServerUpdateAttributes.Property(Attributes.ENTITY_INTERACTION_RANGE, this.config.getScale(), new ArrayList());
        return new WrapperPlayServerUpdateAttributes(this.getEntityId(), List.of(scale, interactionRange));
    }

    public void teleport(Location location) {
        WrapperPlayServerEntityTeleport teleportPacket = new WrapperPlayServerEntityTeleport(this.getEntityId(), SpigotConversionUtil.fromBukkitLocation((Location)location), false);
        CompletableFuture.runAsync(() -> this.getCurrentLocation().getWorld().getPlayers().forEach(player -> PacketEvents.getAPI().getPlayerManager().sendPacket(player, (PacketWrapper)teleportPacket)));
        this.setCurrentLocation(location);
        if (this.getHologram() != null) {
            this.getHologram().teleport(location.clone().add(0.0, this.getHologramOffset(), 0.0));
        }
    }

    public void remove() {
        if (this.floatTask != -1) {
            Bukkit.getScheduler().cancelTask(this.floatTask);
        }
        WrapperPlayServerDestroyEntities destroyPacket = new WrapperPlayServerDestroyEntities(this.getEntityId());
        this.currentLocation.getWorld().getPlayers().forEach(player -> {
            if (player.isOnline()) {
                PacketEvents.getAPI().getPlayerManager().sendPacket(player, (PacketWrapper)destroyPacket);
            }
        });
        if (this.hologram != null) {
            this.hologram.delete();
        }
    }

    public double trueHeight() {
        if (this.config.getScale() == 1.0) {
            return 1.975f;
        }
        if (this.config.getScale() < 1.0) {
            return (double)1.975f * this.config.getScale();
        }
        return (double)1.975f + this.config.getScale();
    }

    public double getHologramOffset() {
        return this.trueHeight() + this.config.getHologramOffset();
    }

    @Generated
    public float getDEFAULT_ARMOR_STAND_HEIGHT() {
        return this.DEFAULT_ARMOR_STAND_HEIGHT;
    }

    @Generated
    public AirHeadsPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public AirHead getConfig() {
        return this.config;
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    @Generated
    public int getFloatTask() {
        return this.floatTask;
    }

    @Generated
    public Hologram getHologram() {
        return this.hologram;
    }

    @Generated
    public long getActiveAfter() {
        return this.activeAfter;
    }

    @Generated
    public void setCurrentLocation(Location currentLocation) {
        this.currentLocation = currentLocation;
    }

    @Generated
    public com.github.retrooper.packetevents.protocol.item.ItemStack getHeadItem() {
        return this.headItem;
    }
}

