/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.PacketEntityCache;
import not.savage.airheads.commands.CmdAirHeads;
import not.savage.airheads.config.AirHead;
import not.savage.airheads.config.AirHeadsConfig;
import not.savage.airheads.config.Config;
import not.savage.airheads.listener.PacketInterceptListener;
import not.savage.airheads.listener.PlayerListener;
import not.savage.airheads.utility.ConfigBuilder;
import not.savage.shade.hologrambridge.HologramBridge;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AirHeadsPlugin
extends JavaPlugin {
    private Config airHeadsConfig;
    private PacketEntityCache packetEntityCache;

    public void onEnable() {
        Instant start = Instant.now();
        this.getLogger().info("Loading ShockAirHeads Plugin!");
        if (!this.setupHologramBridge()) {
            this.getLogger().severe("Failed to setup HologramBridge!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfig();
        this.getLogger().info("Loaded ShockAirHeads config from " + this.getDataFolder().getAbsolutePath() + "/airheads.yml");
        this.getLogger().info("Setting up packet based entities...");
        this.packetEntityCache = new PacketEntityCache(this);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new PacketInterceptListener(this), PacketListenerPriority.NORMAL);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.spawnFakeEntities();
        this.registerCommands();
        this.getLogger().info("Registered `/airheads reload` command.");
        this.getLogger().info(String.format("ShockAirHeads Plugin loaded in %sms", Duration.between(start, Instant.now()).toMillis()));
    }

    public void onDisable() {
        this.getLogger().info("Shutting down Shock ShockAirHeads Plugin!");
        this.getPacketEntityCache().clear();
    }

    public void reloadPlugin() {
        this.getLogger().info("Reloading ShockAirHeads Plugin!");
        this.loadConfig();
        this.packetEntityCache.clear();
        this.spawnFakeEntities();
        Bukkit.getOnlinePlayers().forEach(player -> this.packetEntityCache.showWorld((Player)player));
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("airheads");
        CmdAirHeads handler = new CmdAirHeads(this);
        if (command == null) {
            this.getLogger().severe("Failed to register command.");
            return;
        }
        command.setExecutor((CommandExecutor)handler);
        command.setTabCompleter((TabCompleter)handler);
    }

    private void loadConfig() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            this.getLogger().severe("Failed to create data folder!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (new File(this.getDataFolder(), "config.yml").exists()) {
            this.migrateConfig();
        }
        if (this.airHeadsConfig == null) {
            this.airHeadsConfig = new ConfigBuilder<Config>(Config.class).withPath(new File(this.getDataFolder(), "airheads.yml").toPath()).build();
        }
    }

    public void saveUpdates() {
        CompletableFuture.runAsync(() -> new ConfigBuilder<Config>(Config.class).withPath(new File(this.getDataFolder(), "airheads.yml").toPath()).save(this.airHeadsConfig));
    }

    private void spawnFakeEntities() {
        long offsetTicks;
        long offset = offsetTicks = this.airHeadsConfig.getFloatAnimationOffsetTicks();
        for (Map.Entry<String, AirHead> airHead : this.airHeadsConfig.getAirHeads().entrySet()) {
            AirHeadEntity airHeadEntity = new AirHeadEntity(this, airHead.getKey(), airHead.getValue(), offset);
            this.packetEntityCache.addEntity(airHeadEntity.getEntityId(), airHeadEntity);
            offset += offsetTicks;
        }
    }

    private boolean setupHologramBridge() {
        Plugin hologramBridge = Bukkit.getPluginManager().getPlugin("HologramBridge");
        if (hologramBridge != null && hologramBridge.isEnabled()) {
            this.getLogger().info("HologramBridge found!");
            return true;
        }
        try {
            Class.forName("not.savage.shade.hologrambridge.HologramAPI");
            this.initializeHologramBridge();
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("You have installed the wrong version of Shock AirHeads! The AirHeads versioninstalled does not include HologramBridge, you are meant to have it installed yourself... if you dont want that, you can just download the version which includes it from https://github.com/Savag3life/ShockAirHeads");
            return false;
        }
    }

    private void initializeHologramBridge() {
        this.getLogger().info("Initializing internal HologramBridge...");
        new HologramBridge(this, false);
    }

    private void migrateConfig() {
        this.getLogger().info("Found old config.yml, converting to airheads.yml");
        this.airHeadsConfig = new Config();
        AirHeadsConfig oldConfig = new ConfigBuilder<AirHeadsConfig>(AirHeadsConfig.class).withPath(new File(this.getDataFolder(), "config.yml").toPath()).build();
        if (!oldConfig.getAirHeads().isEmpty()) {
            int x = 0;
            for (AirHead airHead : oldConfig.getAirHeads()) {
                this.airHeadsConfig.getAirHeads().put("name-" + x, airHead);
                ++x;
            }
            new ConfigBuilder<Config>(Config.class).withPath(new File(this.getDataFolder(), "airheads.yml").toPath()).save(this.airHeadsConfig);
            this.getLogger().info("Converted old config.yml to airheads.yml");
            File backup = new File(this.getDataFolder(), "config.yml.backup");
            if (backup.exists()) {
                backup.delete();
            }
            if (!new File(this.getDataFolder(), "config.yml").renameTo(backup)) {
                this.getLogger().warning("Failed to backup old config.yml");
            } else {
                this.getLogger().info("Backed up old config.yml to config.yml.backup");
            }
            if (!new File(this.getDataFolder(), "config.yml").delete()) {
                this.getLogger().warning("Failed to delete old config.yml");
            } else {
                this.getLogger().info("Deleted old config.yml");
            }
        }
    }

    @Generated
    public Config getAirHeadsConfig() {
        return this.airHeadsConfig;
    }

    @Generated
    public PacketEntityCache getPacketEntityCache() {
        return this.packetEntityCache;
    }
}

