/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.util.List;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.AirHeadsPlugin;
import not.savage.airheads.config.AirHead;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.plugin.java.JavaPlugin;

public class AirheadBuilder {
    private final AirHead airHead = new AirHead();
    private final String name;

    public AirheadBuilder(String name) {
        this.name = name;
    }

    public AirheadBuilder setLocation(Location location) {
        this.airHead.setLocation(location);
        return this;
    }

    public AirheadBuilder setHologramText(List<String> hologramText) {
        this.airHead.setHologramText(hologramText);
        return this;
    }

    public AirheadBuilder setHologramText(String ... hologramText) {
        this.airHead.setHologramText(List.of(hologramText));
        return this;
    }

    public AirheadBuilder setHologramOffset(double hologramOffset) {
        this.airHead.setHologramOffset(hologramOffset);
        return this;
    }

    public AirheadBuilder setHeadTexture(String texture) {
        this.airHead.setHeadTexture(texture);
        return this;
    }

    public AirheadBuilder setPlayerInteractCommands(List<String> commands) {
        this.airHead.setInteractCommands(commands);
        return this;
    }

    public AirheadBuilder setInteractConsoleCommand(List<String> commands) {
        this.airHead.setConsoleCommands(commands);
        return this;
    }

    public AirheadBuilder setPlayerInteractMessage(List<String> message) {
        this.airHead.setInteractMessage(message);
        return this;
    }

    public AirheadBuilder playSound(Sound sound, float volume, float pitch) {
        this.airHead.getSoundSettings().setSound(sound);
        this.airHead.getSoundSettings().setVolume(volume);
        this.airHead.getSoundSettings().setPitch(pitch);
        this.airHead.getSoundSettings().setEnabled(true);
        return this;
    }

    public AirheadBuilder noSound() {
        this.airHead.getSoundSettings().setEnabled(false);
        return this;
    }

    public AirheadBuilder setDoFloat(boolean doFloat) {
        this.airHead.setDoFloat(doFloat);
        return this;
    }

    public AirheadBuilder setFloatUpMax(double floatUpMax) {
        this.airHead.setFloatUpMax(floatUpMax);
        return this;
    }

    public AirheadBuilder setFloatDownMax(double floatDownMax) {
        this.airHead.setFloatDownMax(floatDownMax);
        return this;
    }

    public AirheadBuilder setFloatCycleDurationTicks(long floatCycleDurationTicks) {
        this.airHead.setFloatCycleDurationTicks(floatCycleDurationTicks);
        return this;
    }

    public AirheadBuilder setDoRotation(boolean doRotation) {
        this.airHead.setDoRotation(doRotation);
        return this;
    }

    public AirheadBuilder setRotationPerTick(int rotationPerTick) {
        this.airHead.setRotationPerTick(rotationPerTick);
        return this;
    }

    public AirheadBuilder setScale(double scale) {
        this.airHead.setScale(scale);
        return this;
    }

    public AirHeadEntity spawn() {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(AirheadBuilder.class);
        if (plugin instanceof AirHeadsPlugin) {
            AirHeadsPlugin airheads = (AirHeadsPlugin)plugin;
            AirHeadEntity entity = new AirHeadEntity(airheads, this.name, this.airHead, 0L);
            airheads.getPacketEntityCache().addEntity(entity.getEntityId(), entity);
            return entity;
        }
        return null;
    }
}

