/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.AirHeadsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketInterceptListener
implements PacketListener {
    private final AirHeadsPlugin plugin;

    public PacketInterceptListener(AirHeadsPlugin plugin) {
        this.plugin = plugin;
    }

    public void onUserLogin(UserLoginEvent event) {
        this.plugin.getPacketEntityCache().showWorld((Player)event.getPlayer());
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.INTERACT_ENTITY) {
            return;
        }
        WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity(event);
        int entityId = packet.getEntityId();
        AirHeadEntity airHead = this.plugin.getPacketEntityCache().getEntityByEntityId(entityId);
        if (airHead != null) {
            event.setCancelled(true);
            Player player = (Player)event.getPlayer();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                airHead.getConfig().getInteractCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)((CommandSender)event.getPlayer()), (String)cmd));
                airHead.getConfig().getConsoleCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName())));
                if (!airHead.getConfig().getInteractMessage().isEmpty()) {
                    airHead.getConfig().getInteractMessage().forEach(line -> player.sendMessage(MiniMessage.miniMessage().deserialize(line)));
                }
                if (airHead.getConfig().getSoundSettings().isEnabled()) {
                    player.playSound((Entity)player, airHead.getConfig().getSoundSettings().getSound(), airHead.getConfig().getSoundSettings().getVolume(), airHead.getConfig().getSoundSettings().getPitch());
                }
            });
        }
    }
}

