/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.utility.adapter;

import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class LocationConfigAdapter
implements TypeSerializer<Location> {
    private final String LOCATION_WORLD_NODE = "world";
    private final String LOCATION_X_POS_NODE = "x";
    private final String LOCATION_Y_POS_NODE = "y";
    private final String LOCATION_Z_POS_NODE = "z";
    private final String LOCATION_YAW_NODE = "yaw";
    private final String LOCATION_PITCH_NODE = "pitch";

    public Location deserialize(Type type, ConfigurationNode value) throws SerializationException {
        World world;
        String worldId = value.node(new Object[]{"world"}).getString();
        if (worldId == null) {
            throw new SerializationException("World identifier cannot be null");
        }
        if (worldId.contains(":")) {
            NamespacedKey worldKey = (NamespacedKey)value.node(new Object[]{"world"}).get(NamespacedKey.class);
            if (worldKey == null) {
                throw new SerializationException("Invalid world key");
            }
            world = Bukkit.getWorld((NamespacedKey)worldKey);
        } else {
            world = Bukkit.getWorld((String)worldId);
        }
        double x = this.getValueIfPresent(value, "x", Double.class, 0.0);
        double y = this.getValueIfPresent(value, "y", Double.class, 0.0);
        double z = this.getValueIfPresent(value, "z", Double.class, 0.0);
        float yaw = this.getValueIfPresent(value, "yaw", Float.class, Float.valueOf(0.0f)).floatValue();
        float pitch = this.getValueIfPresent(value, "pitch", Float.class, Float.valueOf(0.0f)).floatValue();
        return new Location(world, x, y, z, yaw, pitch);
    }

    public void serialize(Type type, @Nullable Location obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(new Object[]{"world"}).set((Object)obj.getWorld().getName());
        node.node(new Object[]{"x"}).set((Object)obj.getX());
        node.node(new Object[]{"y"}).set((Object)obj.getY());
        node.node(new Object[]{"z"}).set((Object)obj.getZ());
        node.node(new Object[]{"yaw"}).set((Object)Float.valueOf(obj.getYaw()));
        node.node(new Object[]{"pitch"}).set((Object)Float.valueOf(obj.getPitch()));
    }

    private <V> V getValueIfPresent(ConfigurationNode node, String field, Class<V> type, V defValue) throws SerializationException {
        if (!node.hasChild(new Object[]{field})) {
            return defValue;
        }
        return (V)node.node(new Object[]{field}).get(type);
    }
}

