/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.util.List;
import java.util.Optional;
import not.savage.airheads.config.AirHeadConfig;
import not.savage.airheads.hologram.BillboardConstraints;
import not.savage.airheads.hologram.TextAlignment;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;

public class AirHeadBuilder {
    protected final AirHeadConfig airHeadConfig;

    private AirHeadBuilder(Location location) {
        this.airHeadConfig = new AirHeadConfig(location);
    }

    public static AirHeadBuilder create(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        return new AirHeadBuilder(location);
    }

    public AirHeadBuilder setTexture(String texture) {
        if (texture == null || texture.isEmpty()) {
            throw new IllegalArgumentException("Texture cannot be null or empty");
        }
        this.airHeadConfig.getAppearanceSettings().setHeadTexture(texture);
        return this;
    }

    public AirHeadBuilder setScale(float scale) {
        if (scale <= 0.0f) {
            throw new IllegalArgumentException("Scale must be greater than 0");
        }
        this.airHeadConfig.getAppearanceSettings().setScale(scale);
        return this;
    }

    public AirHeadBuilder setOverlayMaterial(Material overlayMaterial) {
        if (overlayMaterial == null) {
            throw new IllegalArgumentException("Overlay material cannot be null");
        }
        this.airHeadConfig.getAppearanceSettings().setOverlayMaterial(overlayMaterial);
        return this;
    }

    public AirHeadBuilder setOverlayOffset(double offset) {
        this.airHeadConfig.getAppearanceSettings().setOverlayOffset(offset);
        return this;
    }

    public AirHeadBuilder setInteractCommands(List<String> interactCommands) {
        if (interactCommands == null || interactCommands.isEmpty()) {
            throw new IllegalArgumentException("Interact commands cannot be null or empty");
        }
        this.airHeadConfig.getInteractSettings().setInteractCommands(interactCommands);
        return this;
    }

    public AirHeadBuilder setLeftClickCommands(List<String> leftClickCommands) {
        if (leftClickCommands == null) {
            throw new IllegalArgumentException("Left click commands cannot be null");
        }
        this.airHeadConfig.getInteractSettings().setLeftClickCommands(leftClickCommands);
        return this;
    }

    public AirHeadBuilder setRightClickCommands(List<String> rightClickCommands) {
        if (rightClickCommands == null) {
            throw new IllegalArgumentException("Right click commands cannot be null");
        }
        this.airHeadConfig.getInteractSettings().setRightClickCommands(rightClickCommands);
        return this;
    }

    public AirHeadBuilder setConsoleCommands(List<String> consoleCommands) {
        if (consoleCommands == null || consoleCommands.isEmpty()) {
            throw new IllegalArgumentException("Console commands cannot be null or empty");
        }
        this.airHeadConfig.getInteractSettings().setConsoleCommands(consoleCommands);
        return this;
    }

    public AirHeadBuilder setLeftClickConsoleCommands(List<String> leftClickConsoleCommands) {
        if (leftClickConsoleCommands == null) {
            throw new IllegalArgumentException("Left click console commands cannot be null");
        }
        this.airHeadConfig.getInteractSettings().setLeftClickConsoleCommands(leftClickConsoleCommands);
        return this;
    }

    public AirHeadBuilder setRightClickConsoleCommands(List<String> rightClickConsoleCommands) {
        if (rightClickConsoleCommands == null) {
            throw new IllegalArgumentException("Right click console commands cannot be null");
        }
        this.airHeadConfig.getInteractSettings().setRightClickConsoleCommands(rightClickConsoleCommands);
        return this;
    }

    public AirHeadBuilder setInteractMessage(List<String> interactMessage) {
        if (interactMessage == null) {
            throw new IllegalArgumentException("Interact message cannot be null");
        }
        this.airHeadConfig.getInteractSettings().setInteractMessage(interactMessage);
        return this;
    }

    public AirHeadBuilder setSound(NamespacedKey sound, float volume, float pitch) {
        if (sound == null) {
            throw new IllegalArgumentException("Sound cannot be null");
        }
        this.airHeadConfig.getInteractSettings().getSoundSettings().setSound(sound);
        this.airHeadConfig.getInteractSettings().getSoundSettings().setVolume(volume);
        this.airHeadConfig.getInteractSettings().getSoundSettings().setPitch(pitch);
        return this;
    }

    public AirHeadBuilder floating(boolean doFloat) {
        this.airHeadConfig.getAnimationSettings().setDoFloat(doFloat);
        return this;
    }

    public AirHeadBuilder floatUpRange(double floatUpMax) {
        this.airHeadConfig.getAnimationSettings().setFloatUpMax(floatUpMax);
        return this;
    }

    public AirHeadBuilder floatDownRange(double floatDownMax) {
        this.airHeadConfig.getAnimationSettings().setFloatDownMax(floatDownMax);
        return this;
    }

    public AirHeadBuilder floatCycleDuration(long floatCycleDurationTicks) {
        this.airHeadConfig.getAnimationSettings().setFloatCycleDurationTicks(floatCycleDurationTicks);
        return this;
    }

    public AirHeadBuilder rotating(boolean doRotation) {
        this.airHeadConfig.getAnimationSettings().setDoRotation(doRotation);
        return this;
    }

    public AirHeadBuilder rotationSpeed(int rotationPerTick) {
        this.airHeadConfig.getAnimationSettings().setRotationPerTick(rotationPerTick);
        return this;
    }

    public AirHeadBuilder hologramText(List<String> hologramText) {
        if (hologramText == null) {
            throw new IllegalArgumentException("Hologram text cannot be null or empty");
        }
        this.airHeadConfig.getHologramTextDisplaySettings().setHologramText(hologramText);
        return this;
    }

    public AirHeadBuilder hologramOffset(double hologramOffset) {
        this.airHeadConfig.getHologramTextDisplaySettings().setHologramOffset(hologramOffset);
        return this;
    }

    public AirHeadBuilder hologramScale(float scaleX, float scaleY, float scaleZ) {
        this.airHeadConfig.getHologramTextDisplaySettings().setScaleX(scaleX);
        this.airHeadConfig.getHologramTextDisplaySettings().setScaleY(scaleY);
        this.airHeadConfig.getHologramTextDisplaySettings().setScaleZ(scaleZ);
        return this;
    }

    public AirHeadBuilder hologramRotation(float translationX, float translationY, float translationZ) {
        this.airHeadConfig.getHologramTextDisplaySettings().setTranslationX(translationX);
        this.airHeadConfig.getHologramTextDisplaySettings().setTranslationY(translationY);
        this.airHeadConfig.getHologramTextDisplaySettings().setTranslationZ(translationZ);
        return this;
    }

    public AirHeadBuilder hologramWidth(int width) {
        this.airHeadConfig.getHologramTextDisplaySettings().setWidth(width);
        return this;
    }

    public AirHeadBuilder hologramHeight(int height) {
        this.airHeadConfig.getHologramTextDisplaySettings().setHeight(height);
        return this;
    }

    public AirHeadBuilder hologramTextShadow(boolean hasTextShadow) {
        this.airHeadConfig.getHologramTextDisplaySettings().setHasTextShadow(hasTextShadow);
        return this;
    }

    public AirHeadBuilder hologramTransparentBackground(boolean transparentBackground) {
        this.airHeadConfig.getHologramTextDisplaySettings().setTransparentBackground(transparentBackground);
        return this;
    }

    public AirHeadBuilder hologramBackgroundColor(String backgroundColor) {
        if (backgroundColor == null || backgroundColor.isEmpty()) {
            throw new IllegalArgumentException("Background color cannot be null or empty");
        }
        this.airHeadConfig.getHologramTextDisplaySettings().setBackgroundColor(backgroundColor);
        return this;
    }

    public AirHeadBuilder hologramShadowRadius(float shadowRadius) {
        this.airHeadConfig.getHologramTextDisplaySettings().setShadowRadius(shadowRadius);
        return this;
    }

    public AirHeadBuilder hologramShadowStrength(float shadowStrength) {
        this.airHeadConfig.getHologramTextDisplaySettings().setShadowStrength(shadowStrength);
        return this;
    }

    public AirHeadBuilder hologramUpdateInterval(int updateIntervalTicks) {
        this.airHeadConfig.getHologramTextDisplaySettings().setUpdateIntervalTicks(updateIntervalTicks);
        return this;
    }

    public AirHeadBuilder hologramRenderDistance(int renderDistance) {
        this.airHeadConfig.getHologramTextDisplaySettings().setRenderDistance(renderDistance);
        return this;
    }

    public AirHeadBuilder hologramBillboardConstraints(BillboardConstraints billboardConstraints) {
        this.airHeadConfig.getHologramTextDisplaySettings().setBillboardConstraints(billboardConstraints.name());
        return this;
    }

    public AirHeadBuilder hologramBillboardConstraints(String billboardConstraints) {
        if (billboardConstraints == null || billboardConstraints.isEmpty()) {
            throw new IllegalArgumentException("Billboard constraints cannot be null or empty");
        }
        Optional<BillboardConstraints> constraints = BillboardConstraints.fromString(billboardConstraints);
        if (constraints.isEmpty()) {
            throw new IllegalArgumentException("Invalid billboard constraints: " + billboardConstraints);
        }
        this.airHeadConfig.getHologramTextDisplaySettings().setBillboardConstraints(constraints.get().name());
        return this;
    }

    public AirHeadBuilder hologramTextAlignment(TextAlignment textAlignment) {
        this.airHeadConfig.getHologramTextDisplaySettings().setTextAlignment(textAlignment.name());
        return this;
    }

    public AirHeadBuilder hologramTextAlignment(String textAlignment) {
        if (textAlignment == null || textAlignment.isEmpty()) {
            throw new IllegalArgumentException("Text alignment cannot be null or empty");
        }
        Optional<TextAlignment> alignment = TextAlignment.fromString(textAlignment);
        if (alignment.isEmpty()) {
            throw new IllegalArgumentException("Invalid text alignment: " + textAlignment);
        }
        this.airHeadConfig.getHologramTextDisplaySettings().setTextAlignment(alignment.get().name());
        return this;
    }

    public AirHeadBuilder hologramPitch(float pitch) {
        this.airHeadConfig.getHologramTextDisplaySettings().setPitch(pitch);
        return this;
    }

    public AirHeadBuilder hologramYaw(float yaw) {
        this.airHeadConfig.getHologramTextDisplaySettings().setYaw(yaw);
        return this;
    }
}

