/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import not.savage.airheads.AirHeadAPI;
import not.savage.airheads.AirHeadBuilder;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.PacketEntityCache;
import not.savage.airheads.commands.CmdAirHeads;
import not.savage.airheads.config.AirHeadConfig;
import not.savage.airheads.config.AirHeadsConfig;
import not.savage.airheads.listener.PacketInterceptListener;
import not.savage.airheads.listener.PlayerListener;
import not.savage.airheads.shade.com.github.retrooper.packetevents.PacketEvents;
import not.savage.airheads.shade.com.github.retrooper.packetevents.event.PacketListenerPriority;
import not.savage.airheads.shade.io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import not.savage.airheads.utility.ConfigBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AirHeadsPlugin
extends JavaPlugin
implements AirHeadAPI {
    private static final String CONFIG_FILE_NAME = "config.yml";
    private AirHeadsConfig airHeadsConfig;
    private PacketEntityCache packetEntityCache;

    public void onLoad() {
        this.getLogger().info("Initializing ShockAirHeads Plugin!");
        try {
            Class.forName("not.savage.airheads.shade.com.github.retrooper.packetevents.PacketEventsAPI");
            this.getLogger().info("Using shaded PacketEvents.");
            PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
            PacketEvents.getAPI().load();
        }
        catch (ClassNotFoundException ignored) {
            this.getLogger().info("Using non-shaded PacketEvents (server dependency).");
        }
    }

    public void onEnable() {
        Instant start = Instant.now();
        this.getLogger().info("Loading ShockAirHeads Plugin!");
        this.loadConfig();
        this.getLogger().info("Loaded ShockAirHeads config from " + this.getDataFolder().getAbsolutePath() + "/config.yml");
        this.getLogger().info("Initializing PacketEvents...");
        PacketEvents.getAPI().init();
        PacketEvents.getAPI().getEventManager().registerListener(new PacketInterceptListener(this), PacketListenerPriority.NORMAL);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getLogger().info("Setting up packet based entities...");
        this.packetEntityCache = new PacketEntityCache(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.spawnFakeEntities();
        this.registerCommands();
        this.getLogger().info("Registered `/airheads reload` command.");
        this.getLogger().info("ShockAirHeads Plugin loaded in %dms".formatted(Duration.between(start, Instant.now()).toMillis()));
    }

    public void onDisable() {
        this.getLogger().info("Shutting down Shock ShockAirHeads Plugin!");
        this.getPacketEntityCache().clear();
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
        PacketEvents.getAPI().terminate();
    }

    public void reloadPlugin(boolean reloadConfig) {
        this.getLogger().info("Reloading ShockAirHeads Plugin!");
        if (reloadConfig) {
            this.loadConfig();
        }
        this.packetEntityCache.clear();
        this.spawnFakeEntities();
        Bukkit.getOnlinePlayers().forEach(player -> this.packetEntityCache.showWorld((Player)player));
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("airheads");
        CmdAirHeads handler = new CmdAirHeads(this);
        if (command == null) {
            this.getLogger().severe("Failed to register command.");
            return;
        }
        command.setExecutor((CommandExecutor)handler);
        command.setTabCompleter((TabCompleter)handler);
    }

    private void loadConfig() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            this.getLogger().severe("Failed to create data folder!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.airHeadsConfig = new ConfigBuilder<AirHeadsConfig>(AirHeadsConfig.class).withPath(new File(this.getDataFolder(), CONFIG_FILE_NAME).toPath()).build();
    }

    public void saveUpdates() {
        CompletableFuture.runAsync(() -> new ConfigBuilder<AirHeadsConfig>(AirHeadsConfig.class).withPath(new File(this.getDataFolder(), CONFIG_FILE_NAME).toPath()).save(this.airHeadsConfig));
    }

    private void spawnFakeEntities() {
        long offsetTicks;
        long offset = offsetTicks = this.airHeadsConfig.getFloatAnimationOffsetTicks();
        for (Map.Entry<String, AirHeadConfig> airHead : this.airHeadsConfig.getAirHeads().entrySet()) {
            AirHeadEntity airHeadEntity = new AirHeadEntity(this, airHead.getKey(), airHead.getValue(), offset);
            this.packetEntityCache.addEntity(airHeadEntity.getEntityId(), airHeadEntity);
            offset += offsetTicks;
        }
    }

    @Override
    public AirHeadEntity spawnAirHead(JavaPlugin plugin, String customId, AirHeadBuilder builder, boolean persistent) {
        AirHeadEntity airHeadEntity = new AirHeadEntity(this, customId, builder.airHeadConfig, 0L);
        this.packetEntityCache.addEntity(airHeadEntity.getEntityId(), airHeadEntity);
        if (persistent) {
            this.airHeadsConfig.getAirHeads().put(customId, builder.airHeadConfig);
            this.saveUpdates();
        }
        return airHeadEntity;
    }

    @Override
    public Optional<AirHeadEntity> getAirHeadEntity(@NonNull String airHeadId) {
        if (airHeadId == null) {
            throw new NullPointerException("airHeadId is marked non-null but is null");
        }
        return Optional.ofNullable(this.packetEntityCache.getByAirHeadName(airHeadId));
    }

    @Override
    public boolean removeAirHead(@NonNull String airHeadId) {
        if (airHeadId == null) {
            throw new NullPointerException("airHeadId is marked non-null but is null");
        }
        AirHeadEntity entity = this.packetEntityCache.getByAirHeadName(airHeadId);
        if (entity != null) {
            entity.remove();
            this.packetEntityCache.removeEntityByName(airHeadId);
            this.airHeadsConfig.getAirHeads().remove(airHeadId);
            this.saveUpdates();
            return true;
        }
        return false;
    }

    @Generated
    public AirHeadsConfig getAirHeadsConfig() {
        return this.airHeadsConfig;
    }

    @Generated
    public PacketEntityCache getPacketEntityCache() {
        return this.packetEntityCache;
    }
}

